/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.content.blocks.kinetics.custom_cogs;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.content.kinetics.base.SingleAxisRotatingVisual;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.INewAxisConnection;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.custom_cogs.CustomCogWheelBlock;
import java.util.function.Consumer;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CustomCogWheelVisual
extends SingleAxisRotatingVisual<BracketedKineticBlockEntity> {
    protected boolean hasShaft;
    protected boolean isHollowed;
    protected RotatingInstance shaft;

    public CustomCogWheelVisual(VisualizationContext context, BracketedKineticBlockEntity be, float partialTick) {
        super(context, (KineticBlockEntity)be, partialTick, CustomCogWheelVisual.getModel(be));
        Block block = ((BracketedKineticBlockEntity)this.blockEntity).getBlockState().getBlock();
        if (!(block instanceof CustomCogWheelBlock)) {
            return;
        }
        CustomCogWheelBlock cog = (CustomCogWheelBlock)block;
        Direction.Axis axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)((KineticBlockEntity)this.blockEntity));
        BlockState state = ((BracketedKineticBlockEntity)this.blockEntity).getBlockState();
        this.hasShaft = cog.cogType.hasShaft;
        this.isHollowed = cog.hasShaftHollowed(state);
        if (this.hasShaft) {
            this.shaft = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.COGWHEEL_SHAFT)).createInstance();
            this.shaft.rotateToFace(axis).setup((KineticBlockEntity)this.blockEntity).setRotationOffset(BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)axis, (BlockPos)this.pos)).setPosition((Vec3i)this.getVisualPosition()).setChanged();
        } else if (cog.isHollowed()) {
            this.shaft = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT)).createInstance();
            if (this.isHollowed) {
                boolean f = true;
                for (Direction dir : Iterate.directions) {
                    BlockState kState;
                    Block block2;
                    if (dir.getAxis() != cog.getRotationAxis(state)) continue;
                    BlockPos offset = this.pos.relative(dir);
                    while (INewAxisConnection.isValidNewShaft(this.level.getBlockState(offset))) {
                        offset = offset.relative(dir);
                    }
                    BlockPos offPosAlt = this.pos.relative(dir.getOpposite());
                    while (INewAxisConnection.isValidNewShaft(this.level.getBlockState(offPosAlt))) {
                        offPosAlt = offPosAlt.relative(dir.getOpposite());
                    }
                    BlockEntity blockEntity = this.level.getBlockEntity(offset);
                    if (!(blockEntity instanceof KineticBlockEntity)) continue;
                    KineticBlockEntity kBE = (KineticBlockEntity)blockEntity;
                    BlockPos source = kBE.source;
                    if (offPosAlt.equals((Object)source) || kBE.getSpeed() == 0.0f || !((block2 = (kState = kBE.getBlockState()).getBlock()) instanceof KineticBlock)) continue;
                    KineticBlock kBlock = (KineticBlock)block2;
                    if (dir.getAxis() != kBlock.getRotationAxis(kState) || !kBlock.hasShaftTowards((LevelReader)this.level, kBE.getBlockPos(), kState, dir)) continue;
                    this.shaft.rotateToFace(axis).setup(kBE).setRotationOffset(BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)axis, (BlockPos)this.pos)).setPosition((Vec3i)this.getVisualPosition());
                    f = false;
                    break;
                }
                if (f) {
                    this.shaft.rotateToFace(axis).setRotationOffset(BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)axis, (BlockPos)this.pos)).setPosition((Vec3i)this.getVisualPosition());
                }
            }
            this.shaft.setChanged();
        }
    }

    public void update(float pt) {
        super.update(pt);
        if (this.shaft != null) {
            Block block = ((BracketedKineticBlockEntity)this.blockEntity).getBlockState().getBlock();
            if (!(block instanceof CustomCogWheelBlock)) {
                return;
            }
            CustomCogWheelBlock cog = (CustomCogWheelBlock)block;
            BlockState state = ((BracketedKineticBlockEntity)this.blockEntity).getBlockState();
            this.hasShaft = cog.cogType.hasShaft;
            this.isHollowed = cog.hasShaftHollowed(state);
            if (this.hasShaft) {
                this.shaft.setup((KineticBlockEntity)this.blockEntity);
            } else if (this.isHollowed) {
                for (Direction dir : Iterate.directions) {
                    BlockState kState;
                    Block block2;
                    if (dir.getAxis() != cog.getRotationAxis(state)) continue;
                    BlockPos offset = this.pos.relative(dir);
                    while (INewAxisConnection.isValidNewShaft(this.level.getBlockState(offset))) {
                        offset = offset.relative(dir);
                    }
                    BlockPos offPosAlt = this.pos.relative(dir.getOpposite());
                    while (INewAxisConnection.isValidNewShaft(this.level.getBlockState(offPosAlt))) {
                        offPosAlt = offPosAlt.relative(dir.getOpposite());
                    }
                    BlockEntity blockEntity = this.level.getBlockEntity(offset);
                    if (!(blockEntity instanceof KineticBlockEntity)) continue;
                    KineticBlockEntity kBE = (KineticBlockEntity)blockEntity;
                    BlockPos source = kBE.source;
                    if (offPosAlt.equals((Object)source) || kBE.getSpeed() == 0.0f || !((block2 = (kState = kBE.getBlockState()).getBlock()) instanceof KineticBlock)) continue;
                    KineticBlock kBlock = (KineticBlock)block2;
                    if (dir.getAxis() != kBlock.getRotationAxis(kState) || !kBlock.hasShaftTowards((LevelReader)this.level, kBE.getBlockPos(), kState, dir)) continue;
                    this.shaft.setup(kBE);
                    break;
                }
            }
            this.shaft.setRotationOffset(BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)this.rotationAxis(), (BlockPos)this.pos)).setChanged();
        }
    }

    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        if (this.shaft != null) {
            this.relight(new FlatLit[]{this.shaft});
        }
    }

    protected void _delete() {
        super._delete();
        if (this.shaft != null) {
            this.shaft.delete();
        }
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        if (this.shaft != null) {
            consumer.accept((Instance)this.shaft);
        }
    }

    public static Model getModel(BracketedKineticBlockEntity be) {
        PartialModel model;
        BlockState state = be.getBlockState();
        Block block = state.getBlock();
        if (block instanceof CustomCogWheelBlock) {
            CustomCogWheelBlock cog = (CustomCogWheelBlock)block;
            model = cog.model;
        } else {
            model = ICogWheel.isLargeCog((BlockState)state) ? AllPartialModels.SHAFTLESS_LARGE_COGWHEEL : AllPartialModels.SHAFTLESS_COGWHEEL;
        }
        return Models.partial((PartialModel)model);
    }
}

