/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.content.blocks.kinetics.custom_cogs;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.DirectionalShaftHalvesBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.simpleRelays.SimpleKineticBlockEntity;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.INewAxisConnection;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.custom_cogs.CustomCogWheelBlock;
import dev.lopyluna.gnkinetics.mixins.RotationPropagatorAccessor;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CustomCogWheelRenderer
extends BracketedKineticBlockEntityRenderer {
    protected boolean hasShaft;

    public CustomCogWheelRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(BracketedKineticBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState state = be.getBlockState();
        Block block = state.getBlock();
        if (!(block instanceof CustomCogWheelBlock)) {
            return;
        }
        CustomCogWheelBlock cog = (CustomCogWheelBlock)block;
        Level level = be.getLevel();
        if (level == null) {
            return;
        }
        BlockPos pos = be.getBlockPos();
        this.hasShaft = cog.cogType.hasShaft;
        boolean isHollowed = cog.hasShaftHollowed(state);
        Direction.Axis axis = CustomCogWheelRenderer.getRotationAxisOf((KineticBlockEntity)be);
        Direction facing = Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        PartialModel model = cog.model;
        CustomCogWheelRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)CachedBuffers.partialFacingVertical((PartialModel)model, (BlockState)state, (Direction)facing), (PoseStack)ms, (VertexConsumer)buffer.getBuffer(RenderType.cutoutMipped()), (int)light);
        if (this.hasShaft) {
            float angle = CustomCogWheelRenderer.getAngleForLargeCogShaft((SimpleKineticBlockEntity)be, (Direction.Axis)axis);
            SuperByteBuffer shaft = CachedBuffers.partialFacingVertical((PartialModel)AllPartialModels.COGWHEEL_SHAFT, (BlockState)state, (Direction)facing);
            CustomCogWheelRenderer.kineticRotationTransform((SuperByteBuffer)shaft, (KineticBlockEntity)be, (Direction.Axis)axis, (float)angle, (int)light);
            shaft.renderInto(ms, buffer.getBuffer(RenderType.solid()));
        } else if (isHollowed) {
            boolean f = true;
            for (Direction dir : Iterate.directions) {
                KineticBlock kBlock;
                BlockState kState;
                Block block2;
                if (dir.getAxis() != cog.getRotationAxis(state)) continue;
                BlockPos offset = pos.relative(dir);
                while (INewAxisConnection.isValidNewShaft(level.getBlockState(offset))) {
                    offset = offset.relative(dir);
                }
                BlockPos offPosAlt = pos.relative(dir.getOpposite());
                while (INewAxisConnection.isValidNewShaft(level.getBlockState(offPosAlt))) {
                    offPosAlt = offPosAlt.relative(dir.getOpposite());
                }
                BlockEntity blockEntity = level.getBlockEntity(offset);
                if (!(blockEntity instanceof KineticBlockEntity)) continue;
                KineticBlockEntity kBE = (KineticBlockEntity)blockEntity;
                Direction oppDir = dir.getOpposite();
                BlockPos source = kBE.source;
                if (offPosAlt.equals((Object)source) || kBE.getSpeed() == 0.0f || !((block2 = (kState = kBE.getBlockState()).getBlock()) instanceof KineticBlock) || !(kBlock = (KineticBlock)block2).hasShaftTowards((LevelReader)level, kBE.getBlockPos(), kState, oppDir)) continue;
                float modifier = RotationPropagatorAccessor.getAxisModifier(kBE, oppDir);
                if (modifier == 0.0f) break;
                float additive = 0.0f;
                boolean shaftOffset = true;
                RenderType render = RenderType.solid();
                if (0.0f > modifier && kBE instanceof DirectionalShaftHalvesBlockEntity) {
                    additive += CustomCogWheelRenderer.getRotationOffsetForPosition((KineticBlockEntity)kBE, (BlockPos)pos, (Direction.Axis)axis);
                    shaftOffset = false;
                }
                float angle = CustomCogWheelRenderer.getAngleForLargeCogShaft(kBE, axis, additive, modifier, shaftOffset);
                SuperByteBuffer shaft = CachedBuffers.partialFacingVertical((PartialModel)AllPartialModels.SHAFT, (BlockState)state, (Direction)facing);
                CustomCogWheelRenderer.kineticRotationTransform((SuperByteBuffer)shaft, (KineticBlockEntity)kBE, (Direction.Axis)axis, (float)angle, (int)light);
                shaft.renderInto(ms, buffer.getBuffer(render));
                f = false;
                break;
            }
            if (f) {
                float angle = CustomCogWheelRenderer.getAngleForLargeCogShaft(axis, pos);
                SuperByteBuffer shaft = CachedBuffers.partialFacingVertical((PartialModel)AllPartialModels.SHAFT, (BlockState)state, (Direction)facing);
                shaft.light(light);
                shaft.rotateCentered(angle, Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis));
                shaft.color(Color.WHITE);
                shaft.renderInto(ms, buffer.getBuffer(RenderType.solid()));
            }
        }
        super.renderSafe(be, partialTicks, ms, buffer, light, overlay);
    }

    public static float getAngleForLargeCogShaft(Direction.Axis axis, BlockPos pos) {
        return CustomCogWheelRenderer.getShaftAngleOffset(axis, pos) % 360.0f / 180.0f * (float)Math.PI;
    }

    public static float getAngleForLargeCogShaft(KineticBlockEntity be, Direction.Axis axis, float additive, float modifier, boolean offset) {
        return (AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel()) * (be.getSpeed() * modifier) * 3.0f / 10.0f + (offset ? CustomCogWheelRenderer.getShaftAngleOffset(axis, be.getBlockPos()) : 0.0f) + additive) % 360.0f / 180.0f * (float)Math.PI;
    }

    public static float getShaftAngleOffset(Direction.Axis axis, BlockPos pos) {
        float offset = 0.0f;
        float d = ((axis == Direction.Axis.X ? 0.0f : (float)pos.getX()) + (axis == Direction.Axis.Y ? 0.0f : (float)pos.getY()) + (axis == Direction.Axis.Z ? 0.0f : (float)pos.getZ())) % 2.0f;
        if (d == 0.0f) {
            offset = 22.5f;
        }
        return offset;
    }
}

