/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.content.blocks.kinetics.custom_cogs;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.AbstractSimpleShaftBlock;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.content.kinetics.speedController.SpeedControllerBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.tterrag.registrate.util.entry.BlockEntry;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.INewAxisConnection;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.custom_cogs.CogType;
import dev.lopyluna.gnkinetics.register.GearsBETypes;
import dev.lopyluna.gnkinetics.register.GearsBlocks;
import dev.lopyluna.gnkinetics.register.GearsShapes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.data.Iterate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CustomCogWheelBlock
extends AbstractSimpleShaftBlock
implements ICogWheel,
INewAxisConnection {
    public static final BooleanProperty HAS_SHAFT = BooleanProperty.create((String)"has_shaft");
    boolean isThick;
    boolean isLarge;
    CogType cogType;
    public PartialModel model;

    public CustomCogWheelBlock(boolean isLarge, boolean isThick, CogType cogType, @NotNull PartialModel model, BlockBehaviour.Properties properties) {
        super(properties);
        this.isLarge = isLarge;
        this.cogType = cogType;
        this.model = model;
        this.isThick = isThick;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)HAS_SHAFT, (Comparable)Boolean.valueOf(false)));
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{HAS_SHAFT}));
    }

    public static CustomCogWheelBlock small(PartialModel model, BlockBehaviour.Properties properties) {
        return new CustomCogWheelBlock(false, false, CogType.SOLID, model, properties);
    }

    public static CustomCogWheelBlock large(PartialModel model, BlockBehaviour.Properties properties) {
        return new CustomCogWheelBlock(true, false, CogType.SOLID, model, properties);
    }

    public static CustomCogWheelBlock smallHollowed(PartialModel model, BlockBehaviour.Properties properties) {
        return new CustomCogWheelBlock(false, false, CogType.HOLLOWED, model, properties);
    }

    public static CustomCogWheelBlock largeHollowed(PartialModel model, BlockBehaviour.Properties properties) {
        return new CustomCogWheelBlock(true, false, CogType.HOLLOWED, model, properties);
    }

    public static CustomCogWheelBlock smallShaftless(PartialModel model, BlockBehaviour.Properties properties) {
        return new CustomCogWheelBlock(false, false, CogType.SHAFTLESS, model, properties);
    }

    public static CustomCogWheelBlock largeShaftless(PartialModel model, BlockBehaviour.Properties properties) {
        return new CustomCogWheelBlock(true, false, CogType.SHAFTLESS, model, properties);
    }

    public static CustomCogWheelBlock smallThick(PartialModel model, BlockBehaviour.Properties properties) {
        return new CustomCogWheelBlock(false, true, CogType.SOLID, model, properties);
    }

    public static CustomCogWheelBlock largeThick(PartialModel model, BlockBehaviour.Properties properties) {
        return new CustomCogWheelBlock(true, true, CogType.SOLID, model, properties);
    }

    public static CustomCogWheelBlock smallHollowedThick(PartialModel model, BlockBehaviour.Properties properties) {
        return new CustomCogWheelBlock(false, true, CogType.HOLLOWED, model, properties);
    }

    public static CustomCogWheelBlock largeHollowedThick(PartialModel model, BlockBehaviour.Properties properties) {
        return new CustomCogWheelBlock(true, true, CogType.HOLLOWED, model, properties);
    }

    public static CustomCogWheelBlock smallShaftlessThick(PartialModel model, BlockBehaviour.Properties properties) {
        return new CustomCogWheelBlock(false, true, CogType.SHAFTLESS, model, properties);
    }

    public static CustomCogWheelBlock largeShaftlessThick(PartialModel model, BlockBehaviour.Properties properties) {
        return new CustomCogWheelBlock(true, true, CogType.SHAFTLESS, model, properties);
    }

    public boolean isHollowed() {
        return this.cogType == CogType.HOLLOWED;
    }

    public boolean hasShaftHollowed(BlockState state) {
        return this.isHollowed() && state.hasProperty((Property)HAS_SHAFT) && (Boolean)state.getValue((Property)HAS_SHAFT) != false;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        boolean hasShaftAlt = false;
        if (this.hitOnShaft(state, context)) {
            if (hasShaftAlt || this.isHollowed() && state.hasProperty((Property)HAS_SHAFT) && ((Boolean)state.getValue((Property)HAS_SHAFT)).booleanValue()) {
                BlockState newState;
                BlockState blockState = newState = hasShaftAlt ? this.remapCycleShaft(state) : (BlockState)state.cycle((Property)HAS_SHAFT);
                if (state.equals(newState)) {
                    return super.onSneakWrenched(state, context);
                }
                KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)Block.updateFromNeighbourShapes((BlockState)newState, (LevelAccessor)level, (BlockPos)pos));
                level.levelEvent(2001, pos, Block.getId((BlockState)AllBlocks.SHAFT.getDefaultState()));
                if (!hasShaftAlt) {
                    this.updateConnections(state, level, pos);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (this.isHollowed() && state.hasProperty((Property)HAS_SHAFT) && ((Boolean)state.getValue((Property)HAS_SHAFT)).booleanValue()) {
            Player player = context.getPlayer();
            if (player == null) {
                super.onSneakWrenched(state, context);
            }
            BlockState newState = BlockHelper.copyProperties((BlockState)state, (BlockState)AllBlocks.SHAFT.getDefaultState());
            boolean creative = player.isCreative();
            if (creative || BlockHelper.findAndRemoveInInventory((BlockState)newState, (Player)player, (int)1) != 0) {
                KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)Block.updateFromNeighbourShapes((BlockState)newState, (LevelAccessor)level, (BlockPos)pos));
                level.levelEvent(2001, pos, Block.getId((BlockState)state));
                if (!creative) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)state.getBlock().asItem().getDefaultInstance());
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.onSneakWrenched(state, context);
    }

    public BlockState remapCycleShaft(BlockState state) {
        Block block = state.getBlock();
        BlockState targetState = state;
        targetState = this.remapCycleShaft(GearsBlocks.COG_STONE, GearsBlocks.SHAFTLESS_COG_STONE, block, targetState);
        targetState = this.remapCycleShaft(GearsBlocks.ANDESITE_COG, GearsBlocks.SHAFTLESS_ANDESITE_COG, block, targetState);
        targetState = this.remapCycleShaft(GearsBlocks.INDUSTRIAL_GEAR, GearsBlocks.SHAFTLESS_INDUSTRIAL_GEAR, block, targetState);
        targetState = this.remapCycleShaft(GearsBlocks.LARGE_INDUSTRIAL_GEAR, GearsBlocks.LARGE_SHAFTLESS_INDUSTRIAL_GEAR, block, targetState);
        targetState = this.remapCycleShaft(GearsBlocks.BRASS_GEAR, GearsBlocks.SHAFTLESS_BRASS_GEAR, block, targetState);
        targetState = this.remapCycleShaft(GearsBlocks.LARGE_BRASS_GEAR, GearsBlocks.LARGE_SHAFTLESS_BRASS_GEAR, block, targetState);
        targetState = this.remapCycleShaft((BlockEntry<? extends Block>)AllBlocks.COGWHEEL, GearsBlocks.SHAFTLESS_COGWHEEL, block, targetState);
        return (targetState = this.remapCycleShaft((BlockEntry<? extends Block>)AllBlocks.LARGE_COGWHEEL, GearsBlocks.LARGE_SHAFTLESS_COGWHEEL, block, targetState)) == state ? state : BlockHelper.copyProperties((BlockState)state, (BlockState)targetState);
    }

    public BlockState remapCycleShaft(BlockEntry<? extends Block> from, BlockEntry<? extends Block> to, Block state, BlockState targetState) {
        if (from.is((Object)state)) {
            targetState = to.getDefaultState();
        }
        if (to.is((Object)state)) {
            targetState = from.getDefaultState();
        }
        return targetState;
    }

    protected boolean hitOnShaft(BlockState state, UseOnContext ray) {
        return AllShapes.SIX_VOXEL_POLE.get(this.getRotationAxis(state)).bounds().inflate(0.001).contains(ray.getClickLocation().subtract(ray.getClickLocation().align(Iterate.axisSet)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean hasShaftAlt;
        boolean bl = hasShaftAlt = !this.cogType.hasShaft && !this.isHollowed();
        if ((hasShaftAlt || this.isHollowed() && state.hasProperty((Property)HAS_SHAFT) && !((Boolean)state.getValue((Property)HAS_SHAFT)).booleanValue()) && (stack.is(AllBlocks.SHAFT.asItem()) || stack.is((Holder)AllItems.ANDESITE_ALLOY))) {
            BlockState newState;
            BlockState blockState = hasShaftAlt ? this.remapCycleShaft(state) : (newState = this.isHollowed() ? (BlockState)state.setValue((Property)HAS_SHAFT, (Comparable)Boolean.valueOf(true)) : state);
            if (state.equals(newState)) {
                return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
            }
            KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)Block.updateFromNeighbourShapes((BlockState)newState, (LevelAccessor)level, (BlockPos)pos));
            SoundType sound = AllBlocks.SHAFT.getDefaultState().getSoundType((LevelReader)level, pos, (Entity)player);
            level.playSound(player, pos, sound.getPlaceSound(), SoundSource.BLOCKS, (sound.getVolume() + 1.0f) / 2.0f, sound.getPitch() * 0.8f);
            level.gameEvent((Holder)GameEvent.BLOCK_PLACE, pos, GameEvent.Context.of((Entity)player, (BlockState)newState));
            if (!hasShaftAlt) {
                this.updateConnections(state, level, pos);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public boolean isLargeCog() {
        return this.isLarge;
    }

    public boolean isSmallCog() {
        return !this.isLarge;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return !this.isThick ? (this.cogType.hasShaft || this.hasShaftHollowed(state) ? (this.isLarge ? AllShapes.LARGE_GEAR : AllShapes.SMALL_GEAR) : (this.isLarge ? GearsShapes.shape(GearsShapes.cuboid(0.0, 6.0, 0.0, 16.0, 10.0, 16.0)).forAxis() : GearsShapes.shape(GearsShapes.cuboid(2.0, 6.0, 2.0, 14.0, 10.0, 14.0)).forAxis())).get((Direction.Axis)state.getValue((Property)AXIS)) : (this.cogType.hasShaft || this.hasShaftHollowed(state) ? (this.isLarge ? GearsShapes.shape(GearsShapes.cuboid(0.0, 2.0, 0.0, 16.0, 14.0, 16.0)).add(AllShapes.SIX_VOXEL_POLE.get(Direction.Axis.Y)).forAxis() : GearsShapes.shape(GearsShapes.cuboid(2.0, 2.0, 2.0, 14.0, 14.0, 14.0)).add(AllShapes.SIX_VOXEL_POLE.get(Direction.Axis.Y)).forAxis()) : (this.isLarge ? GearsShapes.shape(GearsShapes.cuboid(0.0, 2.0, 0.0, 16.0, 14.0, 16.0)).forAxis() : GearsShapes.shape(GearsShapes.cuboid(2.0, 2.0, 2.0, 14.0, 14.0, 14.0)).forAxis())).get((Direction.Axis)state.getValue((Property)AXIS));
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return CustomCogWheelBlock.isValidCogwheelPosition(ICogWheel.isLargeCog((BlockState)state), worldIn, pos, (Direction.Axis)state.getValue((Property)AXIS));
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        if (placer instanceof Player) {
            Player player = (Player)placer;
            this.triggerShiftingGearsAdvancement(worldIn, pos, state, player);
        }
    }

    protected void triggerShiftingGearsAdvancement(Level world, BlockPos pos, BlockState state, Player player) {
        if (world.isClientSide) {
            return;
        }
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)CogWheelBlock.AXIS);
        for (Direction.Axis perpendicular1 : Iterate.axes) {
            if (perpendicular1 == axis) continue;
            Direction d1 = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)perpendicular1);
            for (Direction.Axis perpendicular2 : Iterate.axes) {
                if (perpendicular1 == perpendicular2 || axis == perpendicular2) continue;
                Direction d2 = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)perpendicular2);
                for (int offset1 : Iterate.positiveAndNegative) {
                    for (int offset2 : Iterate.positiveAndNegative) {
                        BlockPos connectedPos = pos.relative(d1, offset1).relative(d2, offset2);
                        BlockState blockState = world.getBlockState(connectedPos);
                        if (!(blockState.getBlock() instanceof CogWheelBlock) || blockState.getValue((Property)CogWheelBlock.AXIS) != axis || ICogWheel.isLargeCog((BlockState)blockState) == this.isLarge) continue;
                        AllAdvancements.COGS.awardTo(player);
                    }
                }
            }
        }
    }

    public static boolean isValidCogwheelPosition(boolean large, LevelReader worldIn, BlockPos pos, Direction.Axis cogAxis) {
        for (Direction facing : Iterate.directions) {
            BlockPos offsetPos;
            BlockState blockState;
            if (facing.getAxis() == cogAxis || (blockState = worldIn.getBlockState(offsetPos = pos.relative(facing))).hasProperty((Property)AXIS) && facing.getAxis() == blockState.getValue((Property)AXIS) || !ICogWheel.isLargeCog((BlockState)blockState) && (!large || !ICogWheel.isSmallCog((BlockState)blockState))) continue;
            return false;
        }
        return true;
    }

    protected Direction.Axis getAxisForPlacement(BlockPlaceContext context) {
        Block block;
        if (context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
            return context.getClickedFace().getAxis();
        }
        Level world = context.getLevel();
        BlockState stateBelow = world.getBlockState(context.getClickedPos().below());
        if (AllBlocks.ROTATION_SPEED_CONTROLLER.has(stateBelow) && this.isLargeCog()) {
            return stateBelow.getValue(SpeedControllerBlock.HORIZONTAL_AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        }
        BlockPos placedOnPos = context.getClickedPos().relative(context.getClickedFace().getOpposite());
        BlockState placedAgainst = world.getBlockState(placedOnPos);
        if (ICogWheel.isSmallCog((BlockState)placedAgainst) && (block = placedAgainst.getBlock()) instanceof IRotate) {
            IRotate rot = (IRotate)block;
            return rot.getRotationAxis(placedAgainst);
        }
        Direction.Axis preferredAxis = CustomCogWheelBlock.getPreferredAxis((BlockPlaceContext)context);
        return preferredAxis != null ? preferredAxis : context.getClickedFace().getAxis();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean shouldWaterlog = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)AXIS, (Comparable)this.getAxisForPlacement(context))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(shouldWaterlog));
    }

    public float getParticleTargetRadius() {
        return this.isLargeCog() ? 1.125f : 0.65f;
    }

    public float getParticleInitialRadius() {
        return this.isLargeCog() ? 1.0f : 0.75f;
    }

    public boolean isDedicatedCogWheel() {
        return true;
    }

    public BlockEntityType<? extends KineticBlockEntity> getBlockEntityType() {
        return (BlockEntityType)GearsBETypes.CUSTOM_COGWHEELS.get();
    }

    public void updateConnection(BlockState thisState, BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof KineticBlockEntity)) {
            return;
        }
        KineticBlockEntity be = (KineticBlockEntity)blockEntity;
        Block block = state.getBlock();
        if (!(block instanceof KineticBlock)) {
            return;
        }
        KineticBlock kinetic = (KineticBlock)block;
        if (be.hasNetwork()) {
            be.getOrCreateNetwork().remove(be);
        }
        be.detachKinetics();
        be.removeSource();
        level.markAndNotifyBlock(pos, level.getChunkAt(pos), state, state, 3, 512);
        if (be instanceof GeneratingKineticBlockEntity) {
            GeneratingKineticBlockEntity genBE = (GeneratingKineticBlockEntity)be;
            genBE.reActivateSource = true;
        }
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        this.updateConnections(state, level, pos);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        this.updateConnections(state, level, pos);
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public void updateConnections(BlockState state, Level level, BlockPos pos) {
        if (!level.isClientSide && this.hasShaftHollowed(state)) {
            for (Direction dir : Iterate.directions) {
                IRotate rot;
                BlockPos offset = pos.relative(dir);
                while (INewAxisConnection.isValidNewShaft(level.getBlockState(offset))) {
                    offset = offset.relative(dir);
                }
                BlockState offState = level.getBlockState(offset);
                Block block = offState.getBlock();
                if (!(block instanceof IRotate) || !(rot = (IRotate)block).hasShaftTowards((LevelReader)level, offset, offState, dir.getOpposite()) || !level.isLoaded(offset)) continue;
                this.updateConnection(state, offState, level, offset);
            }
        }
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return this.cogType.hasShaft && super.hasShaftTowards(world, pos, state, face);
    }

    @Override
    public boolean hasNewShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return this.isHollowed() && face.getAxis() == state.getValue((Property)AXIS);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.getValue((Property)AXIS);
    }

    @Override
    public boolean hasNewShaft(BlockState state) {
        return this.hasShaftHollowed(state);
    }

    @Override
    @Nullable
    public Direction.Axis getNewRotationAxis(BlockState state) {
        return this.hasShaftHollowed(state) ? (Direction.Axis)state.getValue((Property)AXIS) : null;
    }
}

