/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.content.blocks.kinetics.creative_gear_motor;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.creative_gear_motor.CreativeGearMotorBE;
import dev.lopyluna.gnkinetics.register.GearsBETypes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class CreativeGearMotorBlock
extends DirectionalKineticBlock
implements SimpleWaterloggedBlock,
ICogWheel,
IBE<CreativeGearMotorBE> {
    public CreativeGearMotorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)super.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        return (BlockState)originalState.setValue((Property)FACING, (Comparable)((Direction)originalState.getValue((Property)FACING)).getOpposite());
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue((Property)FACING)).getAxis();
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AllShapes.PUMP.get((Direction)state.getValue((Property)FACING));
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighbourState, LevelAccessor world, BlockPos pos, BlockPos neighbourPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return state;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState toPlace = super.getStateForPlacement(context);
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        toPlace = ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)toPlace, (BlockPos)pos);
        Direction nearestLookingDirection = context.getNearestLookingDirection();
        Direction targetDirection = context.getPlayer() != null && context.getPlayer().isShiftKeyDown() ? nearestLookingDirection : nearestLookingDirection.getOpposite();
        Direction bestConnectedDirection = null;
        double bestDistance = Double.MAX_VALUE;
        for (Direction d : Iterate.directions) {
            double distance;
            BlockState adjState;
            BlockPos adjPos = pos.relative(d);
            if (!FluidPipeBlock.canConnectTo((BlockAndTintGetter)level, (BlockPos)adjPos, (BlockState)(adjState = level.getBlockState(adjPos)), (Direction)d) || (distance = Vec3.atLowerCornerOf((Vec3i)d.getNormal()).distanceTo(Vec3.atLowerCornerOf((Vec3i)targetDirection.getNormal()))) > bestDistance) continue;
            bestDistance = distance;
            bestConnectedDirection = d;
        }
        if (bestConnectedDirection == null) {
            return toPlace;
        }
        if (bestConnectedDirection.getAxis() == targetDirection.getAxis()) {
            return toPlace;
        }
        if (player != null && player.isShiftKeyDown()) {
            return toPlace;
        }
        return toPlace != null ? (BlockState)toPlace.setValue((Property)FACING, bestConnectedDirection) : null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
        super.createBlockStateDefinition(builder);
    }

    public boolean hideStressImpact() {
        return true;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public Class<CreativeGearMotorBE> getBlockEntityClass() {
        return CreativeGearMotorBE.class;
    }

    public BlockEntityType<? extends CreativeGearMotorBE> getBlockEntityType() {
        return (BlockEntityType)GearsBETypes.MOTOR.get();
    }
}

