/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.content.blocks.kinetics.cog_crank;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.cog_crank.CogCrankBlock;
import java.util.function.Predicate;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CogCrankItem
extends BlockItem {
    boolean large;
    private final int placementHelperId;
    private final int integratedCogHelperId;

    public CogCrankItem(CogCrankBlock block, Item.Properties properties) {
        super((Block)block, properties);
        this.large = block.isLarge;
        this.placementHelperId = PlacementHelpers.register((IPlacementHelper)(this.large ? new LargeCogHelper() : new SmallCogHelper()));
        this.integratedCogHelperId = PlacementHelpers.register((IPlacementHelper)(this.large ? new IntegratedLargeCogHelper() : new IntegratedSmallCogHelper()));
    }

    @NotNull
    public InteractionResult onItemUseFirst(@NotNull ItemStack stack, UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        IPlacementHelper helper = PlacementHelpers.get((int)this.placementHelperId);
        Player player = context.getPlayer();
        BlockHitResult ray = new BlockHitResult(context.getClickLocation(), context.getClickedFace(), pos, true);
        if (helper.matchesState(state) && player != null && !player.isShiftKeyDown()) {
            return helper.getOffset(player, level, state, pos, ray).placeInWorld(level, (BlockItem)this, player, context.getHand(), ray).result();
        }
        if (this.integratedCogHelperId != -1 && (helper = PlacementHelpers.get((int)this.integratedCogHelperId)).matchesState(state) && player != null && !player.isShiftKeyDown()) {
            return helper.getOffset(player, level, state, pos, ray).placeInWorld(level, (BlockItem)this, player, context.getHand(), ray).result();
        }
        return super.onItemUseFirst(stack, context);
    }

    @MethodsReturnNonnullByDefault
    private static class LargeCogHelper
    extends DiagonalCogHelper {
        private LargeCogHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return ((Predicate<ItemStack>)ICogWheel::isLargeCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        @Override
        public PlacementOffset getOffset(@NotNull Player player, @NotNull Level level, BlockState state, @NotNull BlockPos pos, @NotNull BlockHitResult ray) {
            Block block;
            if (this.hitOnShaft(state, ray)) {
                return PlacementOffset.fail();
            }
            if (ICogWheel.isLargeCog((BlockState)state) && (block = state.getBlock()) instanceof IRotate) {
                IRotate rot = (IRotate)block;
                Direction.Axis axis = rot.getRotationAxis(state);
                Direction side = (Direction)IPlacementHelper.orderedByDistanceOnlyAxis((BlockPos)pos, (Vec3)ray.getLocation(), (Direction.Axis)axis).getFirst();
                for (Direction dir : IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.getLocation(), (Direction.Axis)axis)) {
                    BlockPos newPos = pos.relative(dir).relative(side);
                    if (!CogWheelBlock.isValidCogwheelPosition((boolean)true, (LevelReader)level, (BlockPos)newPos, (Direction.Axis)dir.getAxis()) || !level.getBlockState(newPos).canBeReplaced()) continue;
                    EnumProperty axisProp = BlockStateProperties.AXIS;
                    DirectionProperty facingProp = BlockStateProperties.FACING;
                    return PlacementOffset.success((Vec3i)newPos, s -> s.hasProperty((Property)axisProp) ? (BlockState)s.setValue((Property)axisProp, (Comparable)dir.getAxis()) : (s.hasProperty((Property)facingProp) ? (BlockState)s.setValue((Property)facingProp, (Comparable)Direction.fromAxisAndDirection((Direction.Axis)dir.getAxis(), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)) : s));
                }
                return PlacementOffset.fail();
            }
            return super.getOffset(player, level, state, pos, ray);
        }
    }

    @MethodsReturnNonnullByDefault
    private static class SmallCogHelper
    extends DiagonalCogHelper {
        private SmallCogHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return ((Predicate<ItemStack>)ICogWheel::isSmallCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        @Override
        public PlacementOffset getOffset(@NotNull Player player, @NotNull Level level, BlockState state, @NotNull BlockPos pos, @NotNull BlockHitResult ray) {
            Block block;
            if (this.hitOnShaft(state, ray)) {
                return PlacementOffset.fail();
            }
            if (!ICogWheel.isLargeCog((BlockState)state) && (block = state.getBlock()) instanceof IRotate) {
                IRotate rot = (IRotate)block;
                Direction.Axis axis = rot.getRotationAxis(state);
                for (Direction dir : IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.getLocation(), (Direction.Axis)axis)) {
                    BlockPos newPos = pos.relative(dir);
                    if (!CogWheelBlock.isValidCogwheelPosition((boolean)false, (LevelReader)level, (BlockPos)newPos, (Direction.Axis)axis) || !level.getBlockState(newPos).canBeReplaced()) continue;
                    EnumProperty axisProp = BlockStateProperties.AXIS;
                    DirectionProperty facingProp = BlockStateProperties.FACING;
                    return PlacementOffset.success((Vec3i)newPos, s -> s.hasProperty((Property)axisProp) ? (BlockState)s.setValue((Property)axisProp, (Comparable)axis) : (s.hasProperty((Property)facingProp) ? (BlockState)s.setValue((Property)facingProp, (Comparable)Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)) : s));
                }
                return PlacementOffset.fail();
            }
            return super.getOffset(player, level, state, pos, ray);
        }
    }

    @MethodsReturnNonnullByDefault
    public static class IntegratedLargeCogHelper
    implements IPlacementHelper {
        public Predicate<ItemStack> getItemPredicate() {
            return ((Predicate<ItemStack>)ICogWheel::isLargeCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        public Predicate<BlockState> getStatePredicate() {
            return s -> !ICogWheel.isDedicatedCogWheel((Block)s.getBlock()) && ICogWheel.isSmallCog((BlockState)s);
        }

        public PlacementOffset getOffset(@NotNull Player player, @NotNull Level level, BlockState state, @NotNull BlockPos pos, BlockHitResult ray) {
            Direction face = ray.getDirection();
            Direction.Axis newAxis = state.hasProperty(HorizontalKineticBlock.HORIZONTAL_FACING) ? ((Direction)state.getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getAxis() : (state.hasProperty((Property)DirectionalKineticBlock.FACING) ? ((Direction)state.getValue((Property)DirectionalKineticBlock.FACING)).getAxis() : (state.hasProperty((Property)RotatedPillarKineticBlock.AXIS) ? (Direction.Axis)state.getValue((Property)RotatedPillarKineticBlock.AXIS) : Direction.Axis.Y));
            if (face.getAxis() == newAxis) {
                return PlacementOffset.fail();
            }
            for (Direction dir : IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.getLocation(), (Direction.Axis)face.getAxis(), (Direction.Axis)newAxis)) {
                BlockPos newPos = pos.relative(face).relative(dir);
                if (!level.getBlockState(newPos).canBeReplaced()) continue;
                if (!CogWheelBlock.isValidCogwheelPosition((boolean)false, (LevelReader)level, (BlockPos)newPos, (Direction.Axis)newAxis)) {
                    return PlacementOffset.fail();
                }
                EnumProperty axisProp = BlockStateProperties.AXIS;
                DirectionProperty facingProp = BlockStateProperties.FACING;
                return PlacementOffset.success((Vec3i)newPos, s -> s.hasProperty((Property)axisProp) ? (BlockState)s.setValue((Property)axisProp, (Comparable)newAxis) : (s.hasProperty((Property)facingProp) ? (BlockState)s.setValue((Property)facingProp, (Comparable)Direction.fromAxisAndDirection((Direction.Axis)newAxis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)) : s));
            }
            return PlacementOffset.fail();
        }
    }

    @MethodsReturnNonnullByDefault
    public static class IntegratedSmallCogHelper
    implements IPlacementHelper {
        public Predicate<ItemStack> getItemPredicate() {
            return ((Predicate<ItemStack>)ICogWheel::isSmallCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        public Predicate<BlockState> getStatePredicate() {
            return s -> !ICogWheel.isDedicatedCogWheel((Block)s.getBlock()) && ICogWheel.isSmallCog((BlockState)s);
        }

        public PlacementOffset getOffset(@NotNull Player player, @NotNull Level level, BlockState state, @NotNull BlockPos pos, BlockHitResult ray) {
            Direction face = ray.getDirection();
            Direction.Axis newAxis = state.hasProperty(HorizontalKineticBlock.HORIZONTAL_FACING) ? ((Direction)state.getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getAxis() : (state.hasProperty((Property)DirectionalKineticBlock.FACING) ? ((Direction)state.getValue((Property)DirectionalKineticBlock.FACING)).getAxis() : (state.hasProperty((Property)RotatedPillarKineticBlock.AXIS) ? (Direction.Axis)state.getValue((Property)RotatedPillarKineticBlock.AXIS) : Direction.Axis.Y));
            if (face.getAxis() == newAxis) {
                return PlacementOffset.fail();
            }
            for (Direction d : IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.getLocation(), (Direction.Axis)newAxis)) {
                BlockPos newPos = pos.relative(d);
                if (!level.getBlockState(newPos).canBeReplaced()) continue;
                if (!CogWheelBlock.isValidCogwheelPosition((boolean)false, (LevelReader)level, (BlockPos)newPos, (Direction.Axis)newAxis)) {
                    return PlacementOffset.fail();
                }
                EnumProperty axisProp = BlockStateProperties.AXIS;
                DirectionProperty facingProp = BlockStateProperties.FACING;
                return PlacementOffset.success().at((Vec3i)newPos).withTransform(s -> s.hasProperty((Property)axisProp) ? (BlockState)s.setValue((Property)axisProp, (Comparable)newAxis) : (s.hasProperty((Property)facingProp) ? (BlockState)s.setValue((Property)facingProp, (Comparable)Direction.fromAxisAndDirection((Direction.Axis)newAxis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)) : s));
            }
            return PlacementOffset.fail();
        }
    }

    @MethodsReturnNonnullByDefault
    public static abstract class DiagonalCogHelper
    implements IPlacementHelper {
        public Predicate<BlockState> getStatePredicate() {
            return s -> ICogWheel.isSmallCog((BlockState)s) || ICogWheel.isLargeCog((BlockState)s);
        }

        public PlacementOffset getOffset(@NotNull Player player, @NotNull Level level, BlockState state, @NotNull BlockPos pos, @NotNull BlockHitResult ray) {
            Block block = state.getBlock();
            if (block instanceof IRotate) {
                IRotate rot = (IRotate)block;
                Direction.Axis axis = rot.getRotationAxis(state);
                Direction closest = (Direction)IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.getLocation(), (Direction.Axis)axis).getFirst();
                for (Direction dir : IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.getLocation(), (Direction.Axis)axis, d -> d.getAxis() != closest.getAxis())) {
                    BlockPos newPos = pos.relative(dir).relative(closest);
                    if (!level.getBlockState(newPos).canBeReplaced() || !CogWheelBlock.isValidCogwheelPosition((boolean)ICogWheel.isLargeCog((BlockState)state), (LevelReader)level, (BlockPos)newPos, (Direction.Axis)axis)) continue;
                    EnumProperty axisProp = BlockStateProperties.AXIS;
                    DirectionProperty facingProp = BlockStateProperties.FACING;
                    return PlacementOffset.success((Vec3i)newPos, s -> s.hasProperty((Property)axisProp) ? (BlockState)s.setValue((Property)axisProp, (Comparable)axis) : (s.hasProperty((Property)facingProp) ? (BlockState)s.setValue((Property)facingProp, (Comparable)Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)) : s));
                }
            }
            return PlacementOffset.fail();
        }

        protected boolean hitOnShaft(BlockState state, BlockHitResult ray) {
            IRotate rot;
            Block block = state.getBlock();
            return block instanceof IRotate && AllShapes.SIX_VOXEL_POLE.get((rot = (IRotate)block).getRotationAxis(state)).bounds().inflate(0.001).contains(ray.getLocation().subtract(ray.getLocation().align(Iterate.axisSet)));
        }
    }
}

