/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.content.blocks.kinetics.chainned_cog.packets;

import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.chainned_cog.ChainableCogwheelBE;
import dev.lopyluna.gnkinetics.register.GearsConfigs;
import dev.lopyluna.gnkinetics.register.GearsPackets;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ChainableCogwheelConnectionPacket
extends BlockEntityConfigurationPacket<ChainableCogwheelBE> {
    public static final StreamCodec<RegistryFriendlyByteBuf, ChainableCogwheelConnectionPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, packet -> packet.pos, (StreamCodec)BlockPos.STREAM_CODEC, packet -> packet.targetPos, (StreamCodec)ItemStack.STREAM_CODEC, packet -> packet.chain, (StreamCodec)ByteBufCodecs.BOOL, packet -> packet.connect, ChainableCogwheelConnectionPacket::new);
    private final BlockPos targetPos;
    private final ItemStack chain;
    private final boolean connect;

    public ChainableCogwheelConnectionPacket(BlockPos pos, BlockPos targetPos, ItemStack chain, boolean connect) {
        super(pos);
        this.targetPos = targetPos;
        this.chain = chain;
        this.connect = connect;
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return GearsPackets.CHAIN_COGWHEEL_CONNECT;
    }

    protected int maxRange() {
        return (Integer)GearsConfigs.server().kinetics.maxChainableCogwheelLength.get() + 16;
    }

    protected void applySettings(ServerPlayer player, ChainableCogwheelBE be) {
        Level level = be.getLevel();
        BlockPos pos = be.getBlockPos();
        if (level == null) {
            return;
        }
        if (!pos.closerThan((Vec3i)this.targetPos, (double)(this.maxRange() - 16 + 1))) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(this.targetPos);
        if (!(blockEntity instanceof ChainableCogwheelBE)) {
            return;
        }
        ChainableCogwheelBE clbe = (ChainableCogwheelBE)blockEntity;
        if (this.connect && !player.isCreative()) {
            int chainCost = ChainConveyorBlockEntity.getChainCost((BlockPos)this.targetPos.subtract((Vec3i)pos));
            boolean hasEnough = ChainConveyorBlockEntity.getChainsFromInventory((Player)player, (ItemStack)this.chain, (int)chainCost, (boolean)true);
            if (!hasEnough) {
                return;
            }
            ChainConveyorBlockEntity.getChainsFromInventory((Player)player, (ItemStack)this.chain, (int)chainCost, (boolean)false);
        }
        if (!this.connect) {
            if (!player.isCreative()) {
                for (int chainCost = ChainConveyorBlockEntity.getChainCost((BlockPos)this.targetPos.subtract((Vec3i)pos)); chainCost > 0; chainCost -= 64) {
                    player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)Items.CHAIN, Math.min(chainCost, 64)));
                }
            }
            be.chainDestroyed(this.targetPos.subtract((Vec3i)pos), false, true);
            level.playSound(null, player.blockPosition(), SoundEvents.CHAIN_BREAK, SoundSource.BLOCKS);
        }
        if (this.connect) {
            if (clbe.cantAddConnectionTo(pos)) {
                return;
            }
        } else {
            clbe.removeConnectionTo(pos);
        }
        if (this.connect) {
            if (be.cantAddConnectionTo(this.targetPos)) {
                clbe.removeConnectionTo(pos);
            }
        } else {
            be.removeConnectionTo(this.targetPos);
        }
    }
}

