/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.content.blocks.kinetics.chainned_cog.handlers;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.chainned_cog.ChainableCogwheelBE;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.chainned_cog.packets.ServerboundChainableCogwheelRidingPacket;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class ChainableCogwheelRidingHandler {
    public static BlockPos ridingChainConveyor;
    public static float chainPosition;
    public static BlockPos ridingConnection;
    public static boolean flipped;
    public static int catchingUp;

    public static void embark(BlockPos lift, float position, BlockPos connection) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        ridingChainConveyor = lift;
        chainPosition = position;
        ridingConnection = connection;
        catchingUp = 20;
        BlockEntity blockEntity = mc.level.getBlockEntity(ridingChainConveyor);
        if (blockEntity instanceof ChainableCogwheelBE) {
            ChainableCogwheelBE ccbe = (ChainableCogwheelBE)blockEntity;
            flipped = ccbe.getSpeed() < 0.0f;
        }
        MutableComponent component = Component.translatable((String)"mount.onboard", (Object[])new Object[]{mc.options.keyShift.getTranslatedKeyMessage()});
        mc.gui.setOverlayMessage((Component)component, false);
        mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.CHAIN_HIT, (float)1.0f, (float)0.5f));
    }

    public static void clientTick() {
        Vec3 targetPosition;
        if (ridingChainConveyor == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return;
        }
        if (mc.isPaused()) {
            return;
        }
        if (!AllTags.AllItemTags.CHAIN_RIDEABLE.matches(mc.player.getMainHandItem())) {
            ChainableCogwheelRidingHandler.stopRiding();
            return;
        }
        BlockEntity blockEntity = mc.level.getBlockEntity(ridingChainConveyor);
        if (mc.player.isShiftKeyDown() || !(blockEntity instanceof ChainableCogwheelBE)) {
            ChainableCogwheelRidingHandler.stopRiding();
            return;
        }
        ChainableCogwheelBE ccbe = (ChainableCogwheelBE)blockEntity;
        if (ridingConnection != null && !ccbe.connections.contains(ridingConnection)) {
            ChainableCogwheelRidingHandler.stopRiding();
            return;
        }
        ccbe.prepareStats();
        float chainYOffset = 0.5f * mc.player.getScale();
        Vec3 playerPosition = mc.player.position().add(0.0, mc.player.getBoundingBox().getYsize() + (double)chainYOffset, 0.0);
        ChainableCogwheelRidingHandler.updateTargetPosition(mc, ccbe);
        blockEntity = mc.level.getBlockEntity(ridingChainConveyor);
        if (!(blockEntity instanceof ChainableCogwheelBE)) {
            return;
        }
        ccbe = (ChainableCogwheelBE)blockEntity;
        ccbe.prepareStats();
        if (ridingConnection != null) {
            ChainConveyorBlockEntity.ConnectionStats stats = ccbe.connectionStats.get(ridingConnection);
            targetPosition = stats.start().add(stats.end().subtract(stats.start()).normalize().scale((double)Math.min(stats.chainLength(), chainPosition)));
        } else {
            targetPosition = Vec3.atBottomCenterOf((Vec3i)ridingChainConveyor).add(VecHelper.rotate((Vec3)new Vec3(0.0, 0.5, 1.0), (double)chainPosition, (Direction.Axis)Direction.Axis.Y));
        }
        if (catchingUp > 0) {
            --catchingUp;
        }
        Vec3 diff = targetPosition.subtract(playerPosition);
        if (catchingUp == 0 && (diff.length() > 3.0 || diff.y < -1.0)) {
            ChainableCogwheelRidingHandler.stopRiding();
            return;
        }
        mc.player.setDeltaMovement(mc.player.getDeltaMovement().scale(0.5).add(diff.scale(0.25)));
        if (AnimationTickHolder.getTicks() % 10 == 0) {
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new ServerboundChainableCogwheelRidingPacket(ridingChainConveyor, false));
        }
    }

    private static void stopRiding() {
        if (ridingChainConveyor != null) {
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new ServerboundChainableCogwheelRidingPacket(ridingChainConveyor, true));
        }
        ridingChainConveyor = null;
        ridingConnection = null;
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.CHAIN_HIT, (float)0.75f, (float)0.35f));
    }

    private static void updateTargetPosition(Minecraft mc, ChainableCogwheelBE ccbe) {
        float offBranchAngle;
        if (mc.level == null || mc.player == null) {
            return;
        }
        float serverSpeed = ServerSpeedProvider.get();
        float beSpeed = ccbe.getSpeed() * 1.25f;
        float speed = beSpeed / 360.0f;
        float radius = 1.0f;
        float distancePerTick = Math.abs(speed);
        float degreesPerTick = speed / ((float)Math.PI * radius) * 360.0f;
        if (ridingConnection != null) {
            ChainConveyorBlockEntity.ConnectionStats stats = ccbe.connectionStats.get(ridingConnection);
            float length = stats.chainLength();
            if (flipped != beSpeed < 0.0f) {
                flipped = beSpeed < 0.0f;
                ridingChainConveyor = ccbe.getBlockPos().offset((Vec3i)ridingConnection);
                chainPosition = length - chainPosition;
                ridingConnection = ridingConnection.multiply(-1);
                return;
            }
            chainPosition += serverSpeed * distancePerTick;
            if ((chainPosition = Math.min(length, chainPosition)) < length) {
                return;
            }
            BlockEntity blockEntity = mc.level.getBlockEntity(ccbe.getBlockPos().offset((Vec3i)ridingConnection));
            if (blockEntity instanceof ChainableCogwheelBE) {
                ChainableCogwheelBE ccbe2 = (ChainableCogwheelBE)blockEntity;
                chainPosition = ccbe.wrapAngle((float)((beSpeed < 0.0f ? 0 : 180) + 270) + stats.tangentAngle());
                ridingChainConveyor = ccbe2.getBlockPos();
                ridingConnection = null;
            }
            return;
        }
        float prevChainPosition = chainPosition;
        chainPosition += serverSpeed * degreesPerTick;
        chainPosition = ccbe.wrapAngle(chainPosition);
        BlockPos nearestLooking = BlockPos.ZERO;
        double bestDiff = Double.MAX_VALUE;
        for (BlockPos connection : ccbe.connections) {
            double diff = Vec3.atLowerCornerOf((Vec3i)connection).normalize().distanceToSqr(mc.player.getLookAngle().normalize());
            if (diff > bestDiff) continue;
            nearestLooking = connection;
            bestDiff = diff;
        }
        if (nearestLooking == BlockPos.ZERO) {
            return;
        }
        if (!ccbe.loopThresholdCrossed(chainPosition, prevChainPosition, (float)((beSpeed < 0.0f ? 0 : 180) + 270) + (offBranchAngle = ccbe.connectionStats.get(nearestLooking).tangentAngle()))) {
            return;
        }
        chainPosition = 0.0f;
        ridingConnection = nearestLooking;
    }
}

