/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.content.blocks.kinetics.chainned_cog.handlers;

import com.google.common.cache.Cache;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorShape;
import com.simibubi.create.foundation.utility.RaycastHelper;
import com.simibubi.create.foundation.utility.TickBasedCache;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.chainned_cog.handlers.ChainableCogwheelRidingHandler;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.chainned_cog.packets.ChainableCogwheelConnectionPacket;
import dev.lopyluna.gnkinetics.mixins.ChainConveyorOBBAccessor;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.data.WorldAttached;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class ChainableCogwheelInteractionHandler {
    public static WorldAttached<Cache<BlockPos, List<ChainConveyorShape>>> loadedChains = new WorldAttached($ -> new TickBasedCache(60, true));
    public static BlockPos selectedLift;
    public static float selectedChainPosition;
    public static BlockPos selectedConnection;
    public static Vec3 selectedBakedPosition;
    public static ChainConveyorShape selectedShape;

    public static void clientTick() {
        if (!ChainableCogwheelInteractionHandler.isActive()) {
            selectedLift = null;
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        if (mc.player == null) {
            return;
        }
        ItemStack mainHandItem = mc.player.getMainHandItem();
        boolean isWrench = AllTags.AllItemTags.CHAIN_RIDEABLE.matches(mainHandItem);
        boolean dismantling = isWrench && mc.player.isShiftKeyDown();
        double range = mc.player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE) + 1.0;
        Vec3 from = RaycastHelper.getTraceOrigin((Player)mc.player);
        Vec3 to = RaycastHelper.getTraceTarget((Player)mc.player, (double)range, (Vec3)from);
        HitResult hitResult = mc.hitResult;
        double bestDiff = 3.4028234663852886E38;
        if (hitResult != null) {
            bestDiff = hitResult.getLocation().distanceToSqr(from);
        }
        BlockPos bestLift = null;
        ChainConveyorShape bestShape = null;
        selectedConnection = null;
        for (Map.Entry entry : ((Cache)loadedChains.get((LevelAccessor)mc.level)).asMap().entrySet()) {
            BlockPos liftPos = (BlockPos)entry.getKey();
            BlockState liftState = mc.level.getBlockState(liftPos);
            if ((!liftState.hasProperty((Property)BlockStateProperties.AXIS) || liftState.getValue((Property)BlockStateProperties.AXIS) != Direction.Axis.Y) && !dismantling) continue;
            for (ChainConveyorShape shape : (List)entry.getValue()) {
                double distanceToSqr;
                Vec3 liftVec;
                Vec3 intersect;
                if (shape instanceof ChainConveyorShape.ChainConveyorBB && dismantling || (intersect = shape.intersect(from.subtract(liftVec = Vec3.atLowerCornerOf((Vec3i)liftPos)), to.subtract(liftVec))) == null || (distanceToSqr = intersect.add(liftVec).distanceToSqr(from)) > bestDiff) continue;
                bestDiff = distanceToSqr;
                bestLift = liftPos;
                bestShape = shape;
                selectedChainPosition = shape.getChainPosition(intersect);
                if (!(shape instanceof ChainConveyorShape.ChainConveyorOBB)) continue;
                ChainConveyorShape.ChainConveyorOBB obb = (ChainConveyorShape.ChainConveyorOBB)shape;
                selectedConnection = ((ChainConveyorOBBAccessor)obb).connection();
            }
        }
        selectedLift = bestLift;
        if (bestLift == null) {
            return;
        }
        selectedShape = bestShape;
        selectedBakedPosition = bestShape.getVec(bestLift, selectedChainPosition);
        if (!isWrench) {
            Outliner.getInstance().chaseAABB((Object)"ChainPointSelection", new AABB(selectedBakedPosition, selectedBakedPosition)).colored(Color.WHITE).lineWidth(0.16666667f).disableLineNormals();
        }
    }

    private static boolean isActive() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return false;
        }
        ItemStack mainHandItem = mc.player.getMainHandItem();
        return AllTags.AllItemTags.CHAIN_RIDEABLE.matches(mainHandItem);
    }

    public static boolean onUse() {
        if (selectedLift == null) {
            return false;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return false;
        }
        ItemStack mainHandItem = mc.player.getMainHandItem();
        if (AllTags.AllItemTags.CHAIN_RIDEABLE.matches(mainHandItem)) {
            if (!mc.player.isShiftKeyDown()) {
                ChainableCogwheelRidingHandler.embark(selectedLift, selectedChainPosition, selectedConnection);
                return true;
            }
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new ChainableCogwheelConnectionPacket(selectedLift, selectedLift.offset((Vec3i)selectedConnection), mainHandItem, false));
            return true;
        }
        return true;
    }

    public static void drawCustomBlockSelection(PoseStack ms, MultiBufferSource buffer, Vec3 camera) {
        if (selectedLift == null || selectedShape == null) {
            return;
        }
        VertexConsumer vb = buffer.getBuffer(RenderType.lines());
        ms.pushPose();
        ms.translate((double)selectedLift.getX() - camera.x, (double)selectedLift.getY() - camera.y, (double)selectedLift.getZ() - camera.z);
        ChainConveyorShape chainConveyorShape = selectedShape;
        if (chainConveyorShape instanceof ChainConveyorShape.ChainConveyorOBB) {
            ChainConveyorShape.ChainConveyorOBB obb = (ChainConveyorShape.ChainConveyorOBB)chainConveyorShape;
            obb.drawOutline(selectedLift, ms, vb);
        }
        if ((chainConveyorShape = selectedShape) instanceof ChainConveyorShape.ChainConveyorBB) {
            ChainConveyorShape.ChainConveyorBB bb = (ChainConveyorShape.ChainConveyorBB)chainConveyorShape;
            bb.drawOutline(selectedLift, ms, vb);
        }
        ms.popPose();
    }

    @SubscribeEvent
    public static void hideVanillaBlockSelection(RenderHighlightEvent.Block event) {
        if (selectedLift == null || selectedShape == null) {
            return;
        }
        event.setCanceled(true);
    }
}

