/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.content.blocks.kinetics.chainned_cog.handlers;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.blueprint.BlueprintOverlayRenderer;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.chainned_cog.ChainableCogwheelBE;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.chainned_cog.ChainableCogwheelBlock;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.chainned_cog.packets.ChainableCogwheelConnectionPacket;
import dev.lopyluna.gnkinetics.register.GearsBlocks;
import dev.lopyluna.gnkinetics.register.GearsConfigs;
import dev.lopyluna.gnkinetics.register.GearsLang;
import dev.lopyluna.gnkinetics.register.GearsShapes;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class ChainableCogwheelConnectionHandler {
    private static BlockPos firstPos;
    private static ResourceKey<Level> firstDim;

    public static boolean onRightClick() {
        BlockHitResult bhr;
        Minecraft mc = Minecraft.getInstance();
        assert (mc.level != null);
        assert (mc.player != null);
        if (ChainableCogwheelConnectionHandler.isntChain(mc.player.getMainHandItem())) {
            return false;
        }
        if (firstPos == null) {
            return false;
        }
        boolean missed = false;
        HitResult hitResult = mc.hitResult;
        if (hitResult instanceof BlockHitResult && (bhr = (BlockHitResult)hitResult).getType() != HitResult.Type.MISS && !(mc.level.getBlockEntity(bhr.getBlockPos()) instanceof ChainableCogwheelBE)) {
            missed = true;
        }
        if (!mc.player.isShiftKeyDown() && !missed) {
            return false;
        }
        firstPos = null;
        GearsLang.translate("chainable_cogwheel.selection_cleared", new Object[0]).sendStatus((Player)mc.player);
        return true;
    }

    @SubscribeEvent
    public static void onItemUsedOnBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack itemStack = event.getItemStack();
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        Player player = event.getEntity();
        BlockState blockState = level.getBlockState(pos);
        if (!GearsBlocks.CHAINABLE_COGWHEEL.has(blockState)) {
            return;
        }
        if (ChainableCogwheelConnectionHandler.isntChain(itemStack)) {
            return;
        }
        if (!player.mayBuild() || player instanceof FakePlayer) {
            return;
        }
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.CONSUME);
        if (!level.isClientSide()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ChainableCogwheelBE) {
            ChainableCogwheelBE ccbe = (ChainableCogwheelBE)blockEntity;
            if (ccbe.connections.size() >= (Integer)GearsConfigs.server().kinetics.maxChainableCogwheelConnections.get()) {
                GearsLang.translate("chainable_cogwheel.cannot_add_more_connections", new Object[0]).style(ChatFormatting.RED).sendStatus(player);
                return;
            }
        }
        if (firstPos == null || firstDim != level.dimension()) {
            firstPos = pos;
            firstDim = level.dimension();
            player.swing(event.getHand());
            return;
        }
        boolean success = ChainableCogwheelConnectionHandler.validateAndConnect((LevelAccessor)level, pos, player, itemStack, false);
        firstPos = null;
        if (!success) {
            AllSoundEvents.DENY.play(level, player, (Vec3i)pos);
            return;
        }
        SoundType soundtype = Blocks.CHAIN.defaultBlockState().getSoundType();
        level.playSound(player, pos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
    }

    private static boolean isntChain(ItemStack itemStack) {
        return !itemStack.is(Items.CHAIN);
    }

    public static void clientTick() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (firstPos == null || player == null) {
            return;
        }
        BlockEntity sourceLift = player.level().getBlockEntity(firstPos);
        if (firstDim != player.level().dimension() || !(sourceLift instanceof ChainableCogwheelBE)) {
            firstPos = null;
            GearsLang.translate("chainable_cogwheel.selection_cleared", new Object[0]).sendStatus((Player)player);
            return;
        }
        Level level = player.level();
        VoxelShape firstShape = GearsShapes.shape(GearsShapes.cuboid(-3.0, 6.0, -3.0, 19.0, 10.0, 19.0)).forAxis().get((Direction.Axis)level.getBlockState(firstPos).getValue((Property)ChainableCogwheelBlock.AXIS));
        ItemStack stack = player.getMainHandItem();
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (ChainableCogwheelConnectionHandler.isntChain(stack) && ChainableCogwheelConnectionHandler.isntChain(stack = player.getOffhandItem())) {
            return;
        }
        if (hitResult == null || hitResult.getType() != HitResult.Type.BLOCK) {
            Outliner.getInstance().showAABB((Object)"chain_connect", firstShape.bounds().move(firstPos)).lineWidth(0.0625f).colored(0xFFFFFF);
            return;
        }
        BlockHitResult bhr = (BlockHitResult)hitResult;
        BlockPos pos = bhr.getBlockPos();
        BlockState hitState = level.getBlockState(pos);
        if (pos.equals((Object)firstPos)) {
            Outliner.getInstance().showAABB((Object)"chain_connect", firstShape.bounds().move(firstPos)).lineWidth(0.0625f).colored(0xFFFFFF);
            GearsLang.translate("chainable_cogwheel.select_second", new Object[0]).sendStatus((Player)player);
            return;
        }
        if (!(hitState.getBlock() instanceof ChainableCogwheelBlock)) {
            Outliner.getInstance().showAABB((Object)"chain_connect", firstShape.bounds().move(firstPos)).lineWidth(0.0625f).colored(0xFFFFFF);
            return;
        }
        VoxelShape shape = GearsShapes.shape(GearsShapes.cuboid(-3.0, 6.0, -3.0, 19.0, 10.0, 19.0)).forAxis().get((Direction.Axis)hitState.getValue((Property)ChainableCogwheelBlock.AXIS));
        boolean success = ChainableCogwheelConnectionHandler.validateAndConnect((LevelAccessor)level, pos, (Player)player, stack, true);
        if (success) {
            GearsLang.translate("chainable_cogwheel.valid_connection", new Object[0]).style(ChatFormatting.GREEN).sendStatus((Player)player);
        }
        int color = success ? 9817409 : 15359019;
        Direction.Axis axis = hitState.hasProperty((Property)ChainableCogwheelBlock.AXIS) ? (Direction.Axis)hitState.getValue((Property)ChainableCogwheelBlock.AXIS) : Direction.Axis.Y;
        Outliner.getInstance().showAABB((Object)"chain_connect", firstShape.bounds().move(firstPos)).lineWidth(0.0625f).colored(color);
        Outliner.getInstance().showAABB((Object)"chain_connect_to", shape.bounds().move(pos)).lineWidth(0.0625f).colored(color);
        Vec3 from = pos.getCenter();
        Vec3 to = firstPos.getCenter();
        Vec3 diff = from.subtract(to);
        if (diff.length() < 1.0) {
            return;
        }
        Vec3i nor = Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE).getNormal();
        Vec3 normal = diff.cross(new Vec3((double)nor.getX(), (double)nor.getY(), (double)nor.getZ())).normalize().scale(0.75);
        Outliner.getInstance().showLine((Object)"chain_connect_line", from.add(normal), to.add(normal)).lineWidth(0.0625f).colored(color);
        Outliner.getInstance().showLine((Object)"chain_connect_line_1", from.subtract(normal), to.subtract(normal)).lineWidth(0.0625f).colored(color);
    }

    public static Direction.Axis getAxis(LevelAccessor level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return state.hasProperty((Property)ChainableCogwheelBlock.AXIS) ? (Direction.Axis)state.getValue((Property)ChainableCogwheelBlock.AXIS) : null;
    }

    public static boolean validateAndConnect(LevelAccessor level, BlockPos pos, Player player, ItemStack chain, boolean simulate) {
        double horizontalDistance;
        Direction.Axis firstAxis;
        if (!simulate && player.isShiftKeyDown()) {
            GearsLang.translate("chainable_cogwheel.selection_cleared", new Object[0]).sendStatus(player);
            return false;
        }
        if (pos.equals((Object)firstPos)) {
            return false;
        }
        Direction.Axis axis = ChainableCogwheelConnectionHandler.getAxis(level, pos);
        if (axis != (firstAxis = ChainableCogwheelConnectionHandler.getAxis(level, firstPos))) {
            return ChainableCogwheelConnectionHandler.fail("chainable_cogwheel.cannot_connect_axis");
        }
        if (!pos.closerThan((Vec3i)firstPos, (double)((Integer)GearsConfigs.server().kinetics.maxChainableCogwheelLength.get()).intValue())) {
            return ChainableCogwheelConnectionHandler.fail("chainable_cogwheel.too_far");
        }
        if (pos.closerThan((Vec3i)firstPos, 2.5)) {
            return ChainableCogwheelConnectionHandler.fail("chainable_cogwheel.too_close");
        }
        Vec3 diff = Vec3.atLowerCornerOf((Vec3i)pos.subtract((Vec3i)firstPos));
        switch (axis) {
            default: {
                throw new MatchException(null, null);
            }
            case X: {
                double d = diff.multiply(0.0, 1.0, 1.0).length() - 1.5;
                break;
            }
            case Y: {
                double d = diff.multiply(1.0, 0.0, 1.0).length() - 1.5;
                break;
            }
            case Z: {
                double d = horizontalDistance = diff.multiply(1.0, 1.0, 0.0).length() - 1.5;
            }
        }
        if (horizontalDistance <= 0.0 || Math.abs(diff.get(axis)) > 0.0) {
            return ChainableCogwheelConnectionHandler.fail("chainable_cogwheel.cannot_connect_vertically");
        }
        if (Math.abs(diff.get(axis)) / horizontalDistance > 1.0) {
            return ChainableCogwheelConnectionHandler.fail("chainable_cogwheel.too_steep");
        }
        ChainableCogwheelBlock chainConveyorBlock = (ChainableCogwheelBlock)((Object)GearsBlocks.CHAINABLE_COGWHEEL.get());
        ChainableCogwheelBE sourceLift = (ChainableCogwheelBE)chainConveyorBlock.getBlockEntity((BlockGetter)level, firstPos);
        ChainableCogwheelBE targetLift = (ChainableCogwheelBE)chainConveyorBlock.getBlockEntity((BlockGetter)level, pos);
        if (targetLift.connections.size() >= (Integer)GearsConfigs.server().kinetics.maxChainableCogwheelConnections.get()) {
            return ChainableCogwheelConnectionHandler.fail("chainable_cogwheel.cannot_add_more_connections");
        }
        if (targetLift.connections.contains(firstPos.subtract((Vec3i)pos))) {
            return ChainableCogwheelConnectionHandler.fail("chainable_cogwheel.already_connected");
        }
        if (sourceLift == null || targetLift == null) {
            return ChainableCogwheelConnectionHandler.fail("chainable_cogwheel.blocks_invalid");
        }
        if (!player.isCreative()) {
            int chainCost = ChainConveyorBlockEntity.getChainCost((BlockPos)pos.subtract((Vec3i)firstPos));
            boolean hasEnough = ChainConveyorBlockEntity.getChainsFromInventory((Player)player, (ItemStack)chain, (int)chainCost, (boolean)true);
            if (simulate) {
                BlueprintOverlayRenderer.displayChainRequirements((Item)chain.getItem(), (int)chainCost, (boolean)hasEnough);
            }
            if (!hasEnough) {
                return ChainableCogwheelConnectionHandler.fail("chainable_cogwheel.not_enough_chains");
            }
        }
        if (simulate) {
            return true;
        }
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new ChainableCogwheelConnectionPacket(firstPos, pos, chain, true));
        CreateLang.text((String)"").sendStatus(player);
        firstPos = null;
        firstDim = null;
        return true;
    }

    private static boolean fail(String message) {
        assert (Minecraft.getInstance().player != null);
        GearsLang.translate(message, new Object[0]).style(ChatFormatting.RED).sendStatus((Player)Minecraft.getInstance().player);
        return false;
    }
}

