/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.content.blocks.kinetics.chainned_cog;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.chainned_cog.ChainableCogwheelBE;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.chainned_cog.ChainableCogwheelBlock;
import dev.lopyluna.gnkinetics.register.client.GearsPartialModels;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ChainableCogwheelRenderer
extends KineticBlockEntityRenderer<ChainableCogwheelBE> {
    public static final int MIP_DISTANCE = 48;

    public ChainableCogwheelRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(ChainableCogwheelBE be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState state = be.getBlockState();
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)ChainableCogwheelBlock.AXIS);
        Direction facing = Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        ChainableCogwheelRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)CachedBuffers.partialFacingVertical((PartialModel)AllPartialModels.COGWHEEL_SHAFT, (BlockState)state, (Direction)facing), (PoseStack)ms, (VertexConsumer)buffer.getBuffer(RenderType.cutoutMipped()), (int)light);
        ChainableCogwheelRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)CachedBuffers.partialFacingVertical((PartialModel)GearsPartialModels.CHAINABLE_COGWHEEL_CHAINS, (BlockState)state, (Direction)facing), (PoseStack)ms, (VertexConsumer)buffer.getBuffer(RenderType.cutoutMipped()), (int)light);
        ChainableCogwheelRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)CachedBuffers.partialFacingVertical((PartialModel)GearsPartialModels.CHAINABLE_COGWHEEL, (BlockState)state, (Direction)facing), (PoseStack)ms, (VertexConsumer)buffer.getBuffer(RenderType.cutoutMipped()), (int)light);
        this.renderChains(be, axis, ms, buffer, light, overlay);
    }

    private void renderChains(ChainableCogwheelBE be, Direction.Axis axis, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel()) / (360.0f / Math.abs(be.getSpeed() * 1.25f));
        if ((time %= 1.0f) < 0.0f) {
            time += 1.0f;
        }
        float animation = time - 0.5f;
        for (BlockPos dirNor : be.connections) {
            ChainConveyorBlockEntity.ConnectionStats stats;
            Level level = be.getLevel();
            if (level == null || (stats = be.connectionStats.get(dirNor)) == null) continue;
            BlockPos startPos = be.getBlockPos();
            BlockPos endPos = startPos.offset((Vec3i)dirNor);
            float length = stats.chainLength();
            Vec3 end = endPos.getCenter();
            Vec3 start = startPos.getCenter();
            Vec3 diff = end.subtract(start);
            Vec3 dirVec = diff.normalize();
            Quaternionf q = new Quaternionf().rotationTo((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), (Vector3fc)new Vector3f((float)dirVec.x, (float)dirVec.y, (float)dirVec.z));
            Vec3 offDir = VecHelper.rotate((Vec3)dirVec, (double)90.0, (Direction.Axis)axis).scale(0.75);
            Vec3 offset = dirVec.scale(0.5);
            ms.pushPose();
            PoseTransformStack chain = TransformStack.of((PoseStack)ms);
            chain.center();
            chain.translate((float)offDir.x, (float)offDir.y, (float)offDir.z);
            chain.translate((float)offset.x, (float)offset.y, (float)offset.z);
            chain.rotate((Quaternionfc)q);
            chain.uncenter();
            int light1 = LightTexture.pack((int)level.getBrightness(LightLayer.BLOCK, startPos), (int)level.getBrightness(LightLayer.SKY, startPos));
            int light2 = LightTexture.pack((int)level.getBrightness(LightLayer.BLOCK, startPos.offset((Vec3i)dirNor)), (int)level.getBrightness(LightLayer.SKY, startPos.offset((Vec3i)dirNor)));
            boolean far = Minecraft.getInstance().level == be.getLevel() && !Minecraft.getInstance().getBlockEntityRenderDispatcher().camera.getPosition().closerThan((Position)Vec3.atCenterOf((Vec3i)startPos).add((double)((float)dirNor.getX() / 2.0f), (double)((float)dirNor.getY() / 2.0f), (double)((float)dirNor.getZ() / 2.0f)), 48.0);
            ChainConveyorRenderer.renderChain((PoseStack)ms, (MultiBufferSource)buffer, (float)(0.0f > be.getSpeed() ? animation : -animation), (float)length, (int)light1, (int)light2, (boolean)far);
            ms.popPose();
        }
    }

    public int getViewDistance() {
        return 256;
    }

    public boolean shouldRenderOffScreen(@NotNull ChainableCogwheelBE be) {
        return true;
    }

    protected RenderType getRenderType(ChainableCogwheelBE be, BlockState state) {
        return RenderType.cutoutMipped();
    }
}

