/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.content.blocks.kinetics.chainned_cog;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.content.kinetics.speedController.SpeedControllerBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.IHaveBigOutline;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.chainned_cog.ChainableCogwheelBE;
import dev.lopyluna.gnkinetics.register.GearsBETypes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class ChainableCogwheelBlock
extends RotatedPillarKineticBlock
implements IBE<ChainableCogwheelBE>,
ICogWheel,
IHaveBigOutline {
    public ChainableCogwheelBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.getValue((Property)AXIS);
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return super.getShape(state, level, pos, context);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide() && stack.is(Items.CHAIN)) {
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    public BlockState playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
        if (pLevel.isClientSide()) {
            return pState;
        }
        if (!pPlayer.isCreative()) {
            return pState;
        }
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, be -> {
            be.cancelDrops = true;
        });
        return pState;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        InteractionResult result = super.onWrenched(state, context);
        if (result.consumesAction()) {
            this.withBlockEntityDo((BlockGetter)context.getLevel(), context.getClickedPos(), ChainableCogwheelBE::notifyConnectedToValidate);
            return result;
        }
        return result;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return super.onSneakWrenched(state, context);
        }
        this.withBlockEntityDo((BlockGetter)context.getLevel(), context.getClickedPos(), be -> {
            be.cancelDrops = true;
            if (player.isCreative()) {
                return;
            }
            for (BlockPos targetPos : be.connections) {
                for (int chainCost = ChainConveyorBlockEntity.getChainCost((BlockPos)targetPos); chainCost > 0; chainCost -= 64) {
                    player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)Items.CHAIN, Math.min(chainCost, 64)));
                }
            }
        });
        return super.onSneakWrenched(state, context);
    }

    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        return CogWheelBlock.isValidCogwheelPosition((boolean)true, (LevelReader)reader, (BlockPos)pos, (Direction.Axis)((Direction.Axis)state.getValue((Property)AXIS)));
    }

    protected Direction.Axis getAxisForPlacement(BlockPlaceContext pContext) {
        Block block;
        if (pContext.getPlayer() != null && pContext.getPlayer().isShiftKeyDown()) {
            return pContext.getClickedFace().getAxis();
        }
        Level level = pContext.getLevel();
        BlockState stateBelow = level.getBlockState(pContext.getClickedPos().below());
        if (AllBlocks.ROTATION_SPEED_CONTROLLER.has(stateBelow)) {
            return stateBelow.getValue(SpeedControllerBlock.HORIZONTAL_AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        }
        BlockPos placedOnPos = pContext.getClickedPos().relative(pContext.getClickedFace().getOpposite());
        BlockState placedAgainst = level.getBlockState(placedOnPos);
        if (ICogWheel.isSmallCog((BlockState)placedAgainst) && (block = placedAgainst.getBlock()) instanceof IRotate) {
            IRotate block2 = (IRotate)block;
            return block2.getRotationAxis(placedAgainst);
        }
        Direction.Axis preferredAxis = ChainableCogwheelBlock.getPreferredAxis((BlockPlaceContext)pContext);
        return preferredAxis != null ? preferredAxis : pContext.getClickedFace().getAxis();
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)AXIS, (Comparable)this.getAxisForPlacement(pContext));
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.getAxis() == this.getRotationAxis(state);
    }

    public float getParticleTargetRadius() {
        return 1.125f;
    }

    public float getParticleInitialRadius() {
        return 1.0f;
    }

    public boolean isLargeCog() {
        return true;
    }

    public boolean isSmallCog() {
        return false;
    }

    public Class<ChainableCogwheelBE> getBlockEntityClass() {
        return ChainableCogwheelBE.class;
    }

    public BlockEntityType<? extends ChainableCogwheelBE> getBlockEntityType() {
        return (BlockEntityType)GearsBETypes.CHAINABLE_COGWHEEL.get();
    }
}

