/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.content.blocks.kinetics.chainned_cog;

import com.google.common.cache.Cache;
import com.mojang.serialization.Codec;
import com.simibubi.create.api.contraption.transformable.TransformableBlockEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorShape;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.chainned_cog.ChainableCogwheelBlock;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.chainned_cog.ChainableCogwheelShapeBB;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.chainned_cog.handlers.ChainableCogwheelInteractionHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.createmod.catnip.codecs.CatnipCodecUtils;
import net.createmod.catnip.codecs.CatnipCodecs;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ChainableCogwheelBE
extends KineticBlockEntity
implements TransformableBlockEntity {
    public Set<BlockPos> connections = new HashSet<BlockPos>();
    public Map<BlockPos, ChainConveyorBlockEntity.ConnectionStats> connectionStats;
    public boolean reversed;
    public boolean cancelDrops;
    public boolean checkInvalid = true;
    BlockPos chainDestroyedEffectToSend;

    public ChainableCogwheelBE(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.worldPosition).inflate(this.connections.isEmpty() ? 3.0 : 64.0);
    }

    public void lazyTick() {
        super.lazyTick();
        this.updateChainShapes();
    }

    public void tick() {
        super.tick();
        assert (this.level != null);
        if (this.checkInvalid && !this.level.isClientSide()) {
            this.checkInvalid = false;
            this.removeInvalidConnections();
        }
        boolean reversedPreviously = this.reversed;
        this.prepareStats();
        if (reversedPreviously != this.reversed) {
            this.notifyUpdate();
        }
    }

    public void removeInvalidConnections() {
        assert (this.level != null);
        boolean changed = false;
        Iterator<BlockPos> iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            BlockPos nextPos = iterator.next();
            BlockPos targetPos = this.worldPosition.offset((Vec3i)nextPos);
            if (!this.level.isLoaded(targetPos)) continue;
            BlockEntity blockEntity = this.level.getBlockEntity(targetPos);
            if (blockEntity instanceof ChainableCogwheelBE) {
                ChainableCogwheelBE ccbe = (ChainableCogwheelBE)blockEntity;
                if (ccbe.connections.contains(nextPos.multiply(-1))) continue;
            }
            iterator.remove();
            changed = true;
        }
        if (changed) {
            this.notifyUpdate();
        }
    }

    public void notifyConnectedToValidate() {
        assert (this.level != null);
        for (BlockPos blockPos : this.connections) {
            BlockPos target = this.worldPosition.offset((Vec3i)blockPos);
            if (!this.level.isLoaded(target)) continue;
            BlockEntity blockEntity = this.level.getBlockEntity(target);
            if (blockEntity instanceof ChainableCogwheelBE) {
                ChainableCogwheelBE ccbe = (ChainableCogwheelBE)blockEntity;
                if (this.isValid(ccbe, target)) {
                    ccbe.checkInvalid = true;
                    continue;
                }
                this.chainDestroyed(blockPos, !this.cancelDrops, false);
                this.removeConnectionTo(target);
                ccbe.removeConnectionTo(this.worldPosition);
                continue;
            }
            this.chainDestroyed(blockPos, !this.cancelDrops, false);
            this.removeConnectionTo(target);
        }
    }

    public boolean isValid(ChainableCogwheelBE targetBE, BlockPos targetPos) {
        BlockState state = this.getBlockState();
        BlockState targetState = targetBE.getBlockState();
        return state.getValue((Property)BlockStateProperties.AXIS) == targetState.getValue((Property)BlockStateProperties.AXIS);
    }

    public boolean loopThresholdCrossed(float chainPosition, float prevChainPosition, float offBranchAngle) {
        int sign2;
        int sign1 = Mth.sign((double)AngleHelper.getShortestAngleDiff((double)offBranchAngle, (double)prevChainPosition));
        boolean notCrossed = sign1 >= (sign2 = Mth.sign((double)AngleHelper.getShortestAngleDiff((double)offBranchAngle, (double)chainPosition))) && !this.reversed || sign1 <= sign2 && this.reversed;
        return !notCrossed;
    }

    public void notifyUpdate() {
        assert (this.level != null);
        this.level.blockEntityChanged(this.worldPosition);
        this.sendData();
    }

    public void prepareStats() {
        float speed = this.getSpeed();
        if (this.reversed != speed < 0.0f && speed != 0.0f) {
            this.reversed = speed < 0.0f;
            this.connectionStats = null;
        }
        if (this.connectionStats == null) {
            this.connectionStats = new HashMap<BlockPos, ChainConveyorBlockEntity.ConnectionStats>();
            this.connections.forEach(this::calculateConnectionStats);
        }
    }

    private void calculateConnectionStats(BlockPos connection) {
        boolean reversed = this.getSpeed() < 0.0f;
        float offBranchDistance = 180.0f;
        float direction = 57.295776f * (float)Mth.atan2((double)connection.getX(), (double)connection.getZ());
        float angle = this.wrapAngle(direction - offBranchDistance * (float)(reversed ? -1 : 1));
        Vec3 end = this.worldPosition.offset((Vec3i)connection).getCenter();
        Vec3 start = this.worldPosition.getCenter();
        Direction.Axis axis = (Direction.Axis)this.getBlockState().getValue((Property)ChainableCogwheelBlock.AXIS);
        Vec3 diff = end.subtract(start);
        Vec3 dirVec = diff.normalize();
        Vec3 offDir = VecHelper.rotate((Vec3)dirVec, (double)(reversed ? 90.0 : -90.0), (Direction.Axis)axis).scale(0.75);
        end = end.add((double)((float)offDir.x), (double)((float)offDir.y), (double)((float)offDir.z));
        start = start.add((double)((float)offDir.x), (double)((float)offDir.y), (double)((float)offDir.z));
        float length = (float)start.distanceTo(end);
        this.connectionStats.put(connection, new ChainConveyorBlockEntity.ConnectionStats(angle, length, start, end));
    }

    public boolean cantAddConnectionTo(BlockPos target) {
        BlockPos localTargetPos = target.subtract((Vec3i)this.worldPosition);
        boolean added = this.connections.add(localTargetPos);
        if (added) {
            this.notifyUpdate();
            this.calculateConnectionStats(localTargetPos);
            this.updateChainShapes();
        }
        this.detachKinetics();
        this.updateSpeed = true;
        return !added;
    }

    public void chainDestroyed(BlockPos target, boolean spawnDrops, boolean sendEffect) {
        assert (this.level != null);
        int chainCount = ChainConveyorBlockEntity.getChainCost((BlockPos)target);
        if (sendEffect) {
            this.chainDestroyedEffectToSend = target;
            this.sendData();
        }
        if (!spawnDrops) {
            return;
        }
        if (!this.forPointsAlongChains(target, chainCount, vec -> this.level.addFreshEntity((Entity)new ItemEntity(this.level, vec.x, vec.y, vec.z, new ItemStack((ItemLike)Items.CHAIN))))) {
            while (chainCount > 0) {
                Block.popResource((Level)this.level, (BlockPos)this.worldPosition, (ItemStack)new ItemStack((ItemLike)Blocks.CHAIN.asItem(), Math.min(chainCount, 64)));
                chainCount -= 64;
            }
        }
    }

    public void removeConnectionTo(BlockPos target) {
        BlockPos localTarget = target.subtract((Vec3i)this.worldPosition);
        if (!this.connections.contains(localTarget)) {
            return;
        }
        this.detachKinetics();
        this.connections.remove(localTarget);
        this.connectionStats.remove(localTarget);
        this.notifyUpdate();
        this.updateChainShapes();
        this.updateSpeed = true;
    }

    private void updateChainShapes() {
        this.prepareStats();
        ArrayList<ChainableCogwheelShapeBB> shapes = new ArrayList<ChainableCogwheelShapeBB>();
        shapes.add(new ChainableCogwheelShapeBB(Vec3.atBottomCenterOf((Vec3i)BlockPos.ZERO)));
        for (BlockPos target : this.connections) {
            ChainConveyorBlockEntity.ConnectionStats stats = this.connectionStats.get(target);
            if (stats == null) continue;
            Vec3 localStart = stats.start().subtract(Vec3.atLowerCornerOf((Vec3i)this.worldPosition));
            Vec3 localEnd = stats.end().subtract(Vec3.atLowerCornerOf((Vec3i)this.worldPosition));
            shapes.add((ChainableCogwheelShapeBB)new ChainConveyorShape.ChainConveyorOBB(target, localStart, localEnd));
        }
        if (this.level != null && this.level.isClientSide()) {
            ((Cache)ChainableCogwheelInteractionHandler.loadedChains.get((LevelAccessor)this.level)).put((Object)this.worldPosition, shapes);
        }
    }

    public void remove() {
        super.remove();
        if (this.level == null || !this.level.isClientSide()) {
            return;
        }
        for (BlockPos blockPos : this.connections) {
            this.spawnDestroyParticles(blockPos);
        }
    }

    private void spawnDestroyParticles(BlockPos blockPos) {
        assert (this.level != null);
        this.forPointsAlongChains(blockPos, (int)Math.round(Vec3.atLowerCornerOf((Vec3i)blockPos).length() * 8.0), vec -> this.level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.CHAIN.defaultBlockState()), vec.x, vec.y, vec.z, 0.0, 0.0, 0.0));
    }

    public void destroy() {
        super.destroy();
        assert (this.level != null);
        for (BlockPos blockPos : this.connections) {
            this.chainDestroyed(blockPos, !this.cancelDrops, false);
            BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.offset((Vec3i)blockPos));
            if (!(blockEntity instanceof ChainableCogwheelBE)) continue;
            ChainableCogwheelBE ccbe = (ChainableCogwheelBE)blockEntity;
            ccbe.removeConnectionTo(this.worldPosition);
        }
    }

    public boolean forPointsAlongChains(BlockPos connection, int positions, Consumer<Vec3> callback) {
        this.prepareStats();
        ChainConveyorBlockEntity.ConnectionStats stats = this.connectionStats.get(connection);
        if (stats == null) {
            return false;
        }
        Vec3 start = stats.start();
        Vec3 direction = stats.end().subtract(start);
        Vec3 origin = Vec3.atCenterOf((Vec3i)this.worldPosition);
        Vec3 normal = direction.cross(new Vec3(0.0, 1.0, 0.0)).normalize();
        Vec3 offset = start.subtract(origin);
        Vec3 start2 = origin.add(offset.add(normal.scale(-2.0 * normal.dot(offset))));
        for (boolean firstChain : Iterate.trueAndFalse) {
            int steps = positions / 2;
            if (firstChain) {
                steps += positions % 2;
            }
            for (int i = 0; i < steps; ++i) {
                callback.accept((firstChain ? start : start2).add(direction.scale((0.5 + (double)i) / (double)steps)));
            }
        }
        return true;
    }

    public void invalidate() {
        super.invalidate();
        if (this.level != null && this.level.isClientSide()) {
            ((Cache)ChainableCogwheelInteractionHandler.loadedChains.get((LevelAccessor)this.level)).invalidate((Object)this.worldPosition);
        }
    }

    public List<BlockPos> addPropagationLocations(IRotate block, BlockState state, List<BlockPos> neighbours) {
        for (BlockPos offset : BlockPos.betweenClosed((int)-1, (int)-1, (int)-1, (int)1, (int)1, (int)1)) {
            if (offset.distSqr((Vec3i)BlockPos.ZERO) != 2.0) continue;
            neighbours.add(this.worldPosition.offset((Vec3i)offset));
        }
        this.connections.forEach(p -> neighbours.add(this.worldPosition.offset((Vec3i)p)));
        return super.addPropagationLocations(block, state, neighbours);
    }

    protected boolean canPropagateDiagonally(IRotate block, BlockState state) {
        return state.getBlock() instanceof ICogWheel || block instanceof ICogWheel;
    }

    public float propagateRotationTo(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        if (this.connections.contains(target.getBlockPos().subtract((Vec3i)this.worldPosition))) {
            if (!(target instanceof ChainableCogwheelBE)) {
                return 0.0f;
            }
            return 1.0f;
        }
        return super.propagateRotationTo(target, stateFrom, stateTo, diff, connectedViaAxes, connectedViaCogs);
    }

    public void writeSafe(CompoundTag tag, HolderLookup.Provider registries) {
        super.writeSafe(tag, registries);
        tag.put("Connections", (Tag)CatnipCodecUtils.encode((Codec)CatnipCodecs.set((Codec)BlockPos.CODEC), (HolderLookup.Provider)registries, this.connections).orElseThrow());
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        if (clientPacket && this.chainDestroyedEffectToSend != null) {
            compound.put("DestroyEffect", NbtUtils.writeBlockPos((BlockPos)this.chainDestroyedEffectToSend));
            this.chainDestroyedEffectToSend = null;
        }
        compound.put("Connections", (Tag)CatnipCodecUtils.encode((Codec)CatnipCodecs.set((Codec)BlockPos.CODEC), (HolderLookup.Provider)registries, this.connections).orElseThrow());
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        if (clientPacket && compound.contains("DestroyEffect") && this.level != null) {
            this.spawnDestroyParticles(NBTHelper.readBlockPos((CompoundTag)compound, (String)"DestroyEffect"));
        }
        int sizeBefore = this.connections.size();
        this.connections.clear();
        CatnipCodecUtils.decode((Codec)CatnipCodecs.set((Codec)BlockPos.CODEC), (HolderLookup.Provider)registries, (Tag)compound.get("Connections")).ifPresent(this.connections::addAll);
        this.connectionStats = null;
        this.updateChainShapes();
        if (this.connections.size() != sizeBefore && this.level != null && this.level.isClientSide) {
            this.invalidateRenderBoundingBox();
        }
    }

    public float wrapAngle(float angle) {
        if ((angle %= 360.0f) < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public void transform(BlockEntity blockEntity, StructureTransform transform) {
        if (this.connections == null || this.connections.isEmpty()) {
            return;
        }
        this.connections = new HashSet<BlockPos>(this.connections.stream().map(arg_0 -> ((StructureTransform)transform).applyWithoutOffset(arg_0)).toList());
        this.connectionStats = null;
        this.notifyUpdate();
    }
}

