/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics;

import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class GearsUtils {
    public static String safeFullId(ItemLike registryEntry) {
        return GearsUtils.safeFullName(Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)registryEntry.asItem())));
    }

    public static String safeId(ItemLike registryEntry) {
        return GearsUtils.safeName(Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)registryEntry.asItem())));
    }

    public static String safeName(ResourceLocation id) {
        return id.getPath().replace('/', '_');
    }

    public static String safeFullName(ResourceLocation id) {
        return id.getNamespace() + ":" + id.getPath().replace('/', '_');
    }

    public static Item getResolvedItem(ResourceLocation loc) {
        Item item = (Item)BuiltInRegistries.ITEM.get(loc);
        if (item == Items.AIR) {
            System.out.println("\u26a0 Item not yet registered: " + String.valueOf(loc) + " is " + String.valueOf(item));
        }
        return item;
    }
}

