/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics;

import com.google.gson.JsonElement;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import dev.lopyluna.gnkinetics.Gears;
import dev.lopyluna.gnkinetics.content.datagen.DatagenTags;
import dev.lopyluna.gnkinetics.content.datagen.GearsRecipeProvider;
import dev.lopyluna.gnkinetics.content.datagen.recipes.VanillaRecipeGen;
import dev.lopyluna.gnkinetics.register.GearsSoundEvents;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class GearsDatagen {
    public static void gatherDataHighPriority(GatherDataEvent event) {
        if (event.getMods().contains("gnkinetics")) {
            GearsDatagen.addExtraRegistrateData();
        }
    }

    public static void gatherData(GatherDataEvent event) {
        if (!event.getMods().contains("gnkinetics")) {
            return;
        }
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        gen.addProvider(event.includeClient(), (DataProvider)GearsSoundEvents.provider(gen));
        gen.addProvider(event.includeServer(), (DataProvider)new VanillaRecipeGen(output, provider));
        if (event.includeServer()) {
            GearsRecipeProvider.registerAllProcessing(gen, output, provider);
        }
    }

    private static void addExtraRegistrateData() {
        DatagenTags.addGenerators();
        Gears.REG.addDataGenerator(ProviderType.LANG, provider -> {
            BiConsumer<String, String> langConsumer = (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1);
            GearsSoundEvents.provideLang(langConsumer);
        });
    }

    private static void provideDefaultLang(String fileName, BiConsumer<String, String> consumer) {
        String path = "assets/gnkinetics/lang/default/" + fileName + ".json";
        JsonElement jsonElement = FilesHelper.loadJsonResource((String)path);
        if (jsonElement == null) {
            throw new IllegalStateException(String.format("Could not find default lang file: %s", path));
        }
        for (Map.Entry entry : jsonElement.getAsJsonObject().entrySet()) {
            consumer.accept((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
        }
    }
}

