/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.modular_accumulator;

import com.mrh0.createaddition.blocks.modular_accumulator.ModularAccumulatorBlockEntity;
import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.apache.commons.lang3.tuple.Pair;

public class CAConnectivityHandler {
    public static <T extends BlockEntity> void formMulti(T be) {
        SearchCache cache = new SearchCache();
        ArrayList<T> frontier = new ArrayList<T>();
        frontier.add(be);
        CAConnectivityHandler.formMulti(be.getType(), (BlockGetter)be.getLevel(), cache, frontier);
    }

    private static <T extends BlockEntity> void formMulti(BlockEntityType<?> type, BlockGetter level, SearchCache<T> cache, List<T> frontier) {
        PriorityQueue<Pair<Integer, T>> creationQueue = CAConnectivityHandler.makeCreationQueue();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        Direction.Axis mainAxis = ((IMultiBlockEntityContainer)((BlockEntity)frontier.getFirst())).getMainConnectionAxis();
        int minX = mainAxis == Direction.Axis.Y ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        int minY = mainAxis != Direction.Axis.Y ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        int minZ = mainAxis == Direction.Axis.Y ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        for (BlockEntity be : frontier) {
            BlockPos pos = be.getBlockPos();
            minX = Math.min(pos.getX(), minX);
            minY = Math.min(pos.getY(), minY);
            minZ = Math.min(pos.getZ(), minZ);
        }
        if (mainAxis == Direction.Axis.Y) {
            minX -= ((IMultiBlockEntityContainer)((BlockEntity)frontier.getFirst())).getMaxWidth();
        }
        if (mainAxis != Direction.Axis.Y) {
            minY -= ((IMultiBlockEntityContainer)((BlockEntity)frontier.getFirst())).getMaxWidth();
        }
        if (mainAxis == Direction.Axis.Y) {
            minZ -= ((IMultiBlockEntityContainer)((BlockEntity)frontier.getFirst())).getMaxWidth();
        }
        while (!frontier.isEmpty()) {
            BlockEntity part = (BlockEntity)frontier.removeFirst();
            BlockPos partPos = part.getBlockPos();
            if (visited.contains(partPos)) continue;
            visited.add(partPos);
            int amount = CAConnectivityHandler.tryToFormNewMulti(part, cache, true);
            if (amount > 1) {
                creationQueue.add(Pair.of((Object)amount, (Object)part));
            }
            for (Direction.Axis axis : Iterate.axes) {
                T nextBe;
                Direction dir = Direction.get((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis);
                BlockPos next = partPos.relative(dir);
                if (next.getX() <= minX || next.getY() <= minY || next.getZ() <= minZ || visited.contains(next) || (nextBe = CAConnectivityHandler.partAt(type, level, next)) == null || nextBe.isRemoved()) continue;
                frontier.add(nextBe);
            }
        }
        visited.clear();
        while (!creationQueue.isEmpty()) {
            Pair<Integer, T> next = creationQueue.poll();
            BlockEntity toCreate = (BlockEntity)next.getValue();
            if (visited.contains(toCreate.getBlockPos())) continue;
            visited.add(toCreate.getBlockPos());
            CAConnectivityHandler.tryToFormNewMulti(toCreate, cache, false);
        }
    }

    private static <T extends BlockEntity> int tryToFormNewMulti(T be, SearchCache<T> cache, boolean simulate) {
        int bestWidth = 1;
        int bestAmount = -1;
        if (!((IMultiBlockEntityContainer)be).isController()) {
            return 0;
        }
        int radius = ((IMultiBlockEntityContainer)be).getMaxWidth();
        for (int w = 1; w <= radius; ++w) {
            int amount = CAConnectivityHandler.tryToFormNewMultiOfWidth(be, w, cache, true);
            if (amount < bestAmount) continue;
            bestWidth = w;
            bestAmount = amount;
        }
        if (!simulate) {
            ModularAccumulatorBlockEntity ienergy;
            int beWidth = ((IMultiBlockEntityContainer)be).getWidth();
            if (beWidth == bestWidth && beWidth * beWidth * ((IMultiBlockEntityContainer)be).getHeight() == bestAmount) {
                return bestAmount;
            }
            CAConnectivityHandler.splitMultiAndInvalidate(be, cache, false);
            if (be instanceof ModularAccumulatorBlockEntity && (ienergy = (ModularAccumulatorBlockEntity)be).hasAccumulator()) {
                ienergy.setSize(0, bestAmount);
            }
            CAConnectivityHandler.tryToFormNewMultiOfWidth(be, bestWidth, cache, false);
            ((IMultiBlockEntityContainer)be).preventConnectivityUpdate();
            ((IMultiBlockEntityContainer)be).setWidth(bestWidth);
            ((IMultiBlockEntityContainer)be).setHeight(bestAmount / bestWidth / bestWidth);
            ((IMultiBlockEntityContainer)be).notifyMultiUpdated();
        }
        return bestAmount;
    }

    private static <T extends BlockEntity> int tryToFormNewMultiOfWidth(T be, int width, SearchCache<T> cache, boolean simulate) {
        ModularAccumulatorBlockEntity ienergy;
        int amount = 0;
        int height = 0;
        BlockEntityType type = be.getType();
        Level level = be.getLevel();
        if (level == null) {
            return 0;
        }
        BlockPos origin = be.getBlockPos();
        InternalEnergyStorage beEnergy = null;
        if (be instanceof ModularAccumulatorBlockEntity && (ienergy = (ModularAccumulatorBlockEntity)be).hasAccumulator()) {
            beEnergy = ienergy.getEnergy();
        }
        Direction.Axis axis = ((IMultiBlockEntityContainer)be).getMainConnectionAxis();
        block10: for (int yOffset = 0; yOffset < ((IMultiBlockEntityContainer)be).getMaxLength(axis, width); ++yOffset) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    ModularAccumulatorBlockEntity ienergyCon;
                    BlockPos conPos;
                    Direction.Axis conAxis;
                    BlockEntity controller;
                    int otherWidth;
                    BlockPos pos = switch (axis) {
                        default -> throw new MatchException(null, null);
                        case Direction.Axis.X -> origin.offset(yOffset, xOffset, zOffset);
                        case Direction.Axis.Y -> origin.offset(xOffset, yOffset, zOffset);
                        case Direction.Axis.Z -> origin.offset(xOffset, zOffset, yOffset);
                    };
                    Optional<T> part = cache.getOrCache(type, (BlockGetter)level, pos);
                    if (part.isEmpty() || (otherWidth = ((IMultiBlockEntityContainer)(controller = (BlockEntity)part.get())).getWidth()) > width || otherWidth == width && ((IMultiBlockEntityContainer)controller).getHeight() == ((IMultiBlockEntityContainer)be).getMaxLength(axis, width) || axis != (conAxis = ((IMultiBlockEntityContainer)controller).getMainConnectionAxis()) || !(conPos = controller.getBlockPos()).equals((Object)origin) && (axis != Direction.Axis.Y ? axis == Direction.Axis.Z && conPos.getX() < origin.getX() || conPos.getY() < origin.getY() || axis == Direction.Axis.X && conPos.getZ() < origin.getZ() || axis == Direction.Axis.Z && conPos.getX() + otherWidth > origin.getX() + width || conPos.getY() + otherWidth > origin.getY() + width || axis == Direction.Axis.X && conPos.getZ() + otherWidth > origin.getZ() + width : conPos.getX() < origin.getX() || conPos.getZ() < origin.getZ() || conPos.getX() + otherWidth > origin.getX() + width || conPos.getZ() + otherWidth > origin.getZ() + width)) break block10;
                    if (controller instanceof ModularAccumulatorBlockEntity && !(ienergyCon = (ModularAccumulatorBlockEntity)controller).hasAccumulator()) continue;
                }
            }
            amount += width * width;
            ++height;
        }
        if (simulate) {
            return amount;
        }
        Object extraData = ((IMultiBlockEntityContainer)be).getExtraData();
        for (int yOffset = 0; yOffset < height; ++yOffset) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    ModularAccumulatorBlockEntity ienergyPart;
                    BlockPos pos = switch (axis) {
                        default -> throw new MatchException(null, null);
                        case Direction.Axis.X -> origin.offset(yOffset, xOffset, zOffset);
                        case Direction.Axis.Y -> origin.offset(xOffset, yOffset, zOffset);
                        case Direction.Axis.Z -> origin.offset(xOffset, zOffset, yOffset);
                    };
                    T part = CAConnectivityHandler.partAt(type, (BlockGetter)level, pos);
                    if (part == null || part == be) continue;
                    extraData = ((IMultiBlockEntityContainer)be).modifyExtraData(extraData);
                    if (part instanceof ModularAccumulatorBlockEntity && (ienergyPart = (ModularAccumulatorBlockEntity)part).hasAccumulator()) {
                        ModularAccumulatorBlockEntity ienergyBE;
                        InternalEnergyStorage storageAt = ienergyPart.getEnergy();
                        int energyAt = storageAt.getEnergyStored();
                        if (energyAt > 0 && be instanceof ModularAccumulatorBlockEntity && (ienergyBE = (ModularAccumulatorBlockEntity)be).hasAccumulator() && beEnergy != null) {
                            beEnergy.internalProduceEnergy(energyAt);
                        }
                        storageAt.internalConsumeEnergy(storageAt.getMaxEnergyStored());
                    }
                    CAConnectivityHandler.splitMultiAndInvalidate(part, cache, false);
                    ((IMultiBlockEntityContainer)part).setController(origin);
                    ((IMultiBlockEntityContainer)part).preventConnectivityUpdate();
                    cache.put(pos, be);
                    ((IMultiBlockEntityContainer)part).setHeight(height);
                    ((IMultiBlockEntityContainer)part).setWidth(width);
                    ((IMultiBlockEntityContainer)part).notifyMultiUpdated();
                }
            }
        }
        ((IMultiBlockEntityContainer)be).setExtraData(extraData);
        ((IMultiBlockEntityContainer)be).notifyMultiUpdated();
        return amount;
    }

    public static <T extends BlockEntity> void splitMulti(T be) {
        CAConnectivityHandler.splitMultiAndInvalidate(be, null, false);
    }

    private static <T extends BlockEntity> void splitMultiAndInvalidate(T be, @Nullable SearchCache<T> cache, boolean tryReconnect) {
        ModularAccumulatorBlockEntity ienergy;
        ModularAccumulatorBlockEntity ienergyBE;
        ModularAccumulatorBlockEntity ienergyBE2;
        Level level = be.getLevel();
        if (level == null) {
            return;
        }
        if ((be = ((IMultiBlockEntityContainer)be).getControllerBE()) == null) {
            return;
        }
        int height = ((IMultiBlockEntityContainer)be).getHeight();
        int width = ((IMultiBlockEntityContainer)be).getWidth();
        if (width == 1 && height == 1) {
            return;
        }
        BlockPos origin = be.getBlockPos();
        ArrayList<T> frontier = new ArrayList<T>();
        Direction.Axis axis = ((IMultiBlockEntityContainer)be).getMainConnectionAxis();
        int toDistribute = 0;
        int maxCapacity = 0;
        if (be instanceof ModularAccumulatorBlockEntity && (ienergyBE2 = (ModularAccumulatorBlockEntity)be).hasAccumulator()) {
            toDistribute = ienergyBE2.getEnergy().getEnergyStored();
            maxCapacity = ienergyBE2.getSize(0);
            if (!be.isRemoved()) {
                ienergyBE2.getEnergy().internalConsumeEnergy(maxCapacity);
            }
            ienergyBE2.setSize(0, 1);
        }
        for (int yOffset = 0; yOffset < height; ++yOffset) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    BlockPos pos = switch (axis) {
                        default -> throw new MatchException(null, null);
                        case Direction.Axis.X -> origin.offset(yOffset, xOffset, zOffset);
                        case Direction.Axis.Y -> origin.offset(xOffset, yOffset, zOffset);
                        case Direction.Axis.Z -> origin.offset(xOffset, zOffset, yOffset);
                    };
                    T partAt = CAConnectivityHandler.partAt(be.getType(), (BlockGetter)level, pos);
                    if (partAt == null || !((IMultiBlockEntityContainer)partAt).getController().equals((Object)origin)) continue;
                    BlockEntity controllerBE = ((IMultiBlockEntityContainer)partAt).getControllerBE();
                    ((IMultiBlockEntityContainer)partAt).setExtraData(controllerBE == null ? null : ((IMultiBlockEntityContainer)controllerBE).getExtraData());
                    ((IMultiBlockEntityContainer)partAt).removeController(true);
                    if (partAt != be) {
                        int split;
                        InternalEnergyStorage internalEnergyStorage;
                        if (partAt instanceof ModularAccumulatorBlockEntity) {
                            ModularAccumulatorBlockEntity ienergyPart = (ModularAccumulatorBlockEntity)partAt;
                            internalEnergyStorage = ienergyPart.getEnergy();
                        } else {
                            internalEnergyStorage = null;
                        }
                        InternalEnergyStorage tank = internalEnergyStorage;
                        int copy = split = Math.min(maxCapacity, toDistribute);
                        toDistribute -= split;
                        if (tank != null) {
                            tank.internalProduceEnergy(copy);
                        }
                    }
                    if (tryReconnect) {
                        frontier.add(partAt);
                        ((IMultiBlockEntityContainer)partAt).preventConnectivityUpdate();
                    }
                    if (cache == null) continue;
                    cache.put(pos, partAt);
                }
            }
        }
        if (be instanceof ModularAccumulatorBlockEntity && (ienergyBE = (ModularAccumulatorBlockEntity)be).hasAccumulator()) {
            ienergyBE.getEnergy().setEnergy(toDistribute);
        }
        if (be instanceof ModularAccumulatorBlockEntity && (ienergy = (ModularAccumulatorBlockEntity)be).hasAccumulator()) {
            be.getLevel().invalidateCapabilities(be.getBlockPos());
        }
        if (tryReconnect) {
            CAConnectivityHandler.formMulti(be.getType(), (BlockGetter)level, cache == null ? new SearchCache<T>() : cache, frontier);
        }
    }

    private static <T extends BlockEntity> PriorityQueue<Pair<Integer, T>> makeCreationQueue() {
        return new PriorityQueue<Pair<Integer, T>>((one, two) -> (Integer)two.getKey() - (Integer)one.getKey());
    }

    @Nullable
    public static <T extends BlockEntity> T partAt(BlockEntityType<?> type, BlockGetter level, BlockPos pos) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be != null && be.getType() == type && !be.isRemoved()) {
            return CAConnectivityHandler.checked(be);
        }
        return null;
    }

    @Nullable
    private static <T extends BlockEntity> T checked(BlockEntity be) {
        if (be instanceof IMultiBlockEntityContainer) {
            return (T)be;
        }
        return null;
    }

    public static <T extends BlockEntity> boolean isConnected(BlockGetter level, BlockPos pos, BlockPos other) {
        T one = CAConnectivityHandler.checked(level.getBlockEntity(pos));
        T two = CAConnectivityHandler.checked(level.getBlockEntity(other));
        if (one == null || two == null) {
            return false;
        }
        return ((IMultiBlockEntityContainer)one).getController().equals((Object)((IMultiBlockEntityContainer)two).getController());
    }

    private static class SearchCache<T extends BlockEntity> {
        Map<BlockPos, Optional<T>> controllerMap = new HashMap<BlockPos, Optional<T>>();

        void put(BlockPos pos, T target) {
            this.controllerMap.put(pos, Optional.of(target));
        }

        void putEmpty(BlockPos pos) {
            this.controllerMap.put(pos, Optional.empty());
        }

        boolean hasVisited(BlockPos pos) {
            return this.controllerMap.containsKey(pos);
        }

        Optional<T> getOrCache(BlockEntityType<?> type, BlockGetter level, BlockPos pos) {
            if (this.hasVisited(pos)) {
                return this.controllerMap.get(pos);
            }
            Object partAt = CAConnectivityHandler.partAt(type, level, pos);
            if (partAt == null) {
                this.putEmpty(pos);
                return Optional.empty();
            }
            Object controller = CAConnectivityHandler.checked(level.getBlockEntity(((IMultiBlockEntityContainer)partAt).getController()));
            if (controller == null) {
                this.putEmpty(pos);
                return Optional.empty();
            }
            this.put(pos, controller);
            return Optional.of(controller);
        }
    }
}

