/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.barbed_wire;

import com.mrh0.createaddition.config.CommonConfig;
import com.mrh0.createaddition.index.CADamageTypes;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.IShearable;

public class BarbedWireBlock
extends Block
implements IShearable,
SimpleWaterloggedBlock {
    public static final BooleanProperty VERTICAL = BooleanProperty.create((String)"vertical");
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public BarbedWireBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)VERTICAL, (Comparable)Boolean.valueOf(false))).setValue((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        double delta = Math.abs(entity.getX() - entity.xOld) + Math.abs(entity.getY() - entity.yOld) + Math.abs(entity.getZ() - entity.zOld);
        if (entity instanceof LivingEntity && delta > 0.0 && entity.hurt(CADamageTypes.barbedWire(level), ((Double)CommonConfig.BARBED_WIRE_DAMAGE.get()).floatValue())) {
            entity.playSound(SoundEvents.PLAYER_HURT_SWEET_BERRY_BUSH, 1.0f, 1.0f);
        }
        entity.makeStuckInBlock(state, new Vec3(0.25, 0.05, 0.25));
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{VERTICAL, HORIZONTAL_FACING, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext c) {
        FluidState fluidstate = c.getLevel().getFluidState(c.getClickedPos());
        if (c.getPlayer() == null) {
            return this.defaultBlockState();
        }
        if (c.getClickedFace().getAxis() == Direction.Axis.Y) {
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HORIZONTAL_FACING, (Comparable)(c.getPlayer().isShiftKeyDown() ? c.getHorizontalDirection().getClockWise() : c.getHorizontalDirection()))).setValue((Property)VERTICAL, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        }
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HORIZONTAL_FACING, (Comparable)c.getClickedFace().getOpposite())).setValue((Property)VERTICAL, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    public static void makeBlockState(DataGenContext<Block, BarbedWireBlock> ctx, RegistrateBlockstateProvider provider) {
        BlockModelProvider models = provider.models();
        String basePath = "block/barbed_wire/block";
        ModelFile.ExistingModelFile model = models.getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"createaddition", (String)basePath));
        VariantBlockStateBuilder builder = provider.getVariantBuilder((Block)ctx.get());
        builder.forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)model).rotationX((Boolean)state.getValue((Property)VERTICAL) != false ? 90 : 0).rotationY(((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + ((Boolean)state.getValue((Property)VERTICAL) != false ? 0 : 90)) % 360).build());
    }
}

