/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu.util.mod;

import com.terraformersmc.mod_menu.ModMenu;
import com.terraformersmc.mod_menu.TextPlaceholderApiCompat;
import com.terraformersmc.mod_menu.config.ModMenuConfig;
import com.terraformersmc.mod_menu.util.mod.ModBadge;
import com.terraformersmc.mod_menu.util.mod.neoforge.NeoforgeIconHandler;
import eu.pb4.placeholders.api.ParserContext;
import java.awt.Dimension;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.neoforged.fml.ModContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Mod {
    @NotNull
    public String getId();

    @NotNull
    public String getName();

    @NotNull
    default public String getTranslatedName() {
        String translationKey = "mod_menu.nameTranslation." + this.getId();
        if (!I18n.exists((String)translationKey)) {
            translationKey = "modmenu.nameTranslation." + this.getId();
        }
        if (!I18n.exists((String)translationKey)) {
            translationKey = "modmenu.nameTranslation." + this.getId().replace("_", "-");
        }
        if ((this.getId().equals("minecraft") || this.getId().equals("java") || ((Boolean)ModMenu.getConfig().TRANSLATE_NAMES.get()).booleanValue()) && I18n.exists((String)translationKey)) {
            return I18n.get((String)translationKey, (Object[])new Object[0]);
        }
        return this.getName();
    }

    @NotNull
    public Tuple<DynamicTexture, Dimension> getIcon(NeoforgeIconHandler var1, int var2, boolean var3);

    @NotNull
    default public String getSummary() {
        String string = this.getTranslatedSummary();
        return TextPlaceholderApiCompat.PARSER.parseText(string, ParserContext.of()).getString();
    }

    @NotNull
    default public String getTranslatedSummary() {
        String translationKey = "mod_menu.summaryTranslation." + this.getId();
        if (!I18n.exists((String)translationKey)) {
            translationKey = "modmenu.summaryTranslation." + this.getId();
        }
        if (!I18n.exists((String)translationKey)) {
            translationKey = "modmenu.summaryTranslation." + this.getId().replace("_", "-");
        }
        if ((this.getId().equals("minecraft") || this.getId().equals("java") || ((Boolean)ModMenu.getConfig().TRANSLATE_DESCRIPTIONS.get()).booleanValue()) && I18n.exists((String)translationKey)) {
            return I18n.get((String)translationKey, (Object[])new Object[0]);
        }
        return this.getTranslatedDescription();
    }

    @NotNull
    public String getDescription();

    @NotNull
    default public String getTranslatedDescription() {
        String translatableDescriptionKey = "mod_menu.descriptionTranslation." + this.getId();
        if (!I18n.exists((String)translatableDescriptionKey)) {
            translatableDescriptionKey = "modmenu.descriptionTranslation." + this.getId();
        }
        if (!I18n.exists((String)translatableDescriptionKey)) {
            translatableDescriptionKey = "modmenu.descriptionTranslation." + this.getId().replace("_", "-");
        }
        if ((this.getId().equals("minecraft") || this.getId().equals("java") || ((Boolean)ModMenu.getConfig().TRANSLATE_DESCRIPTIONS.get()).booleanValue()) && I18n.exists((String)translatableDescriptionKey)) {
            return I18n.get((String)translatableDescriptionKey, (Object[])new Object[0]);
        }
        return this.getDescription();
    }

    default public Component getFormattedDescription() {
        String string = this.getTranslatedDescription();
        return TextPlaceholderApiCompat.PARSER.parseText(string, ParserContext.of());
    }

    default public void reCalculateBadge() {
        ModMenuConfig config = ModMenu.getConfig();
        config.mod_badges.putIfAbsent(this.getId(), new LinkedHashSet());
        LinkedHashSet<String> defaultBadges = new LinkedHashSet<String>(this.getBadgeNames());
        if (config.disabled_mod_badges.containsKey(this.getId())) {
            defaultBadges.removeAll((Collection)config.disabled_mod_badges.get(this.getId()));
        }
        this.getBadges().clear();
        if (!((Boolean)ModMenu.getConfig().DISABLE_DEFAULT_BADGES_ALL.get()).booleanValue() && !((List)ModMenu.getConfig().DISABLE_DEFAULT_BADGES.get()).contains(this.getId())) {
            this.getBadges().addAll(ModBadge.convert(defaultBadges, this.getId()));
        }
        Set<String> badgelist = config.mod_badges.get(this.getId());
        this.getBadges().addAll(ModBadge.convert(badgelist, this.getId()));
    }

    @NotNull
    public String getVersion();

    @NotNull
    public String getPrefixedVersion();

    @NotNull
    public List<String> getAuthors();

    @NotNull
    public Map<String, Collection<String>> getContributors();

    @NotNull
    public SortedMap<String, Set<String>> getCredits();

    @NotNull
    public Set<ModBadge> getBadges();

    @NotNull
    public Set<String> getBadgeNames();

    @Nullable
    public String getWebsite();

    @Nullable
    public String getIssueTracker();

    @Nullable
    public String getSource();

    @Nullable
    public String getParent();

    @NotNull
    public Set<String> getLicense();

    @NotNull
    public Map<String, String> getLinks();

    public boolean isReal();

    public void setChildHasUpdate();

    public boolean getChildHasUpdate();

    public boolean isHidden();

    public ModMenuData getModMenuData();

    public Optional<ModContainer> getContainer();

    public static class ModMenuData {
        private final Set<ModBadge> badges = new LinkedHashSet<ModBadge>();
        private Optional<String> parent;
        @Nullable
        private final DummyParentData dummyParentData;

        public ModMenuData(Optional<String> parent, DummyParentData dummyParentData, String id) {
            this.parent = parent;
            this.dummyParentData = dummyParentData;
        }

        public Set<ModBadge> getBadges() {
            return this.badges;
        }

        public Optional<String> getParent() {
            return this.parent;
        }

        @Nullable
        public DummyParentData getDummyParentData() {
            return this.dummyParentData;
        }

        public void fillParentIfEmpty(String parent) {
            if (!this.parent.isPresent()) {
                this.parent = Optional.of(parent);
            }
        }

        public static class DummyParentData {
            private final String id;
            private final Optional<String> name;
            private final Optional<String> description;
            private final Optional<String> icon;
            private final Set<String> badges;

            public DummyParentData(String id, Optional<String> name, Optional<String> description, Optional<String> icon, Set<String> badges) {
                this.id = id;
                this.name = name;
                this.description = description;
                this.icon = icon;
                this.badges = badges;
            }

            public String getId() {
                return this.id;
            }

            public Optional<String> getName() {
                return this.name;
            }

            public Optional<String> getDescription() {
                return this.description;
            }

            public Optional<String> getIcon() {
                return this.icon;
            }

            public Set<String> getBadges() {
                return this.badges;
            }
        }
    }
}

