/*
 * Decompiled with CFR 0.152.
 */
package io.socol.betterthirdperson.platform;

import io.socol.betterthirdperson.api.config.CustomCameraConfig;
import io.socol.betterthirdperson.api.config.DefaultCustomCameraConfig;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class CustomCameraConfigImpl
implements CustomCameraConfig {
    private final ModConfigSpec config;
    private final ModConfigSpec.BooleanValue aimOnInteract;
    private final ModConfigSpec.IntValue aimDuration;
    private final ModConfigSpec.IntValue followYaw;
    private final ModConfigSpec.BooleanValue freeCameraDuringElytraFlight;
    private final ModConfigSpec.BooleanValue skipThirdPersonFrontView;
    private final ModConfigSpec.IntValue playerRotationSpeed;
    private final ModConfigSpec.IntValue pitchChangeSpeed;

    public CustomCameraConfigImpl() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        CustomCameraConfig def = DefaultCustomCameraConfig.INSTANCE;
        this.aimOnInteract = builder.comment("Align player to camera on left & right clicks").define("aimPlayerOnInteract", def.shouldAimPlayerOnInteract());
        this.aimDuration = builder.comment("How long player will be aligned to camera after left & right clicks").defineInRange("aimDuration", def.getAimDuration(), 10, 200);
        this.followYaw = builder.comment("Angle in degrees within the player will slightly follow camera yaw (while standing still)").defineInRange("followYaw", def.getFollowYaw(), 0, 90);
        this.freeCameraDuringElytraFlight = builder.comment("Does camera should rotate freely during elytra flight").define("freeCameraDuringElytraFlight", def.hasFreeCameraDuringElytraFlight());
        this.skipThirdPersonFrontView = builder.comment("Completely remove third-person front view").define("skipThirdPersonFrontView", def.skipThirdPersonFrontView());
        this.playerRotationSpeed = builder.comment("How fast player changes movement direction in third-person").defineInRange("playerRotationSpeed", def.getPlayerRotationSpeed(), 10, 100);
        this.pitchChangeSpeed = builder.comment("How fast player pitch follows camera pitch in third-person").defineInRange("pitchChangeSpeed", def.getPitchChangeSpeed(), 10, 100);
        this.config = builder.build();
    }

    public static CustomCameraConfig create(ModContainer modContainer) {
        CustomCameraConfigImpl configImpl = new CustomCameraConfigImpl();
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)configImpl.config);
        return configImpl;
    }

    @Override
    public boolean shouldAimPlayerOnInteract() {
        return (Boolean)this.aimOnInteract.get();
    }

    @Override
    public int getAimDuration() {
        return (Integer)this.aimDuration.get();
    }

    @Override
    public int getFollowYaw() {
        return (Integer)this.followYaw.get();
    }

    @Override
    public boolean hasFreeCameraDuringElytraFlight() {
        return (Boolean)this.freeCameraDuringElytraFlight.get();
    }

    @Override
    public boolean skipThirdPersonFrontView() {
        return (Boolean)this.skipThirdPersonFrontView.get();
    }

    @Override
    public int getPlayerRotationSpeed() {
        return (Integer)this.playerRotationSpeed.get();
    }

    @Override
    public int getPitchChangeSpeed() {
        return (Integer)this.pitchChangeSpeed.get();
    }
}

