/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.block.entity;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.equipment.armor.BacktankBlockEntity;
import com.simibubi.create.foundation.blockEntity.ComparatorUtil;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.tom.createores.OreData;
import com.tom.createores.OreDataAttachment;
import com.tom.createores.Registration;
import com.tom.createores.block.entity.IDrill;
import com.tom.createores.client.ClientUtil;
import com.tom.createores.item.OreVeinAtlasItem;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.DimChunkPos;
import com.tom.createores.util.NumberFormatter;
import com.tom.createores.util.TooltipUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SampleDrillBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IHaveHoveringInformation,
IDrill {
    public static final int DRILL_TIME = 200;
    private ResourceLocation veinClient;
    private long resourceRemClient;
    private RecipeHolder<VeinRecipe> vein;
    private OreData data;
    private int progress = 0;
    private boolean drilling = false;
    private float airTankLevel = -1.0f;

    public SampleDrillBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.setLazyTickRate(20);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        VeinRecipe veinR = this.veinClient != null ? (VeinRecipe)this.level.getRecipeManager().byKey(this.veinClient).filter(e -> e.value() instanceof VeinRecipe).map(r -> (VeinRecipe)r.value()).orElse(null) : null;
        Component vein = veinR != null ? veinR.getName() : Component.translatable((String)"chat.coe.veinFinder.nothing");
        TooltipUtil.forGoggles(tooltip, Component.translatable((String)"chat.coe.veinFinder.found", (Object[])new Object[]{vein}));
        if (!this.level.getBlockState(this.worldPosition.below()).isCollisionShapeFullBlock((BlockGetter)this.level, this.worldPosition.below())) {
            TooltipUtil.forGoggles(tooltip, Component.translatable((String)"info.coe.drill.noGround"));
        }
        if (this.drilling) {
            if (this.progress < 200) {
                TooltipUtil.forGoggles(tooltip, Component.translatable((String)"info.coe.drill.progress").append(": [").append(ClientUtil.makeProgressBar((float)this.progress / 200.0f)).append("]"));
            } else {
                TooltipUtil.forGoggles(tooltip, Component.translatable((String)"info.coe.sample_drill.done"));
            }
        } else if (this.airTankLevel > 0.2f) {
            TooltipUtil.forGoggles(tooltip, Component.translatable((String)"info.coe.sample_drill.click_to_start"));
        }
        if (this.resourceRemClient != 0L) {
            TooltipUtil.forGoggles(tooltip, Component.translatable((String)"info.coe.drill.resourceRemaining", (Object[])new Object[]{NumberFormatter.formatNumber(this.resourceRemClient)}));
        }
        if (this.airTankLevel < 0.0f) {
            TooltipUtil.forGoggles(tooltip, Component.translatable((String)"info.coe.sample_drill.no_air"));
        } else if (this.airTankLevel < 0.21f) {
            TooltipUtil.forGoggles(tooltip, Component.translatable((String)"info.coe.sample_drill.low_air"));
        } else {
            TooltipUtil.forGoggles(tooltip, Component.translatable((String)"info.coe.sample_drill.air").append(": [").append(ClientUtil.makeProgressBar(this.airTankLevel)).append("]"));
        }
        return true;
    }

    private void updateVein() {
        ChunkPos p = new ChunkPos(this.worldPosition);
        this.data = OreDataAttachment.getData(this.level.getChunk(p.x, p.z));
        RecipeManager m = this.level.getRecipeManager();
        if (this.data != null) {
            this.vein = this.data.getRecipe(m);
        }
    }

    public void tick() {
        BlockEntity be;
        super.tick();
        if (!this.level.isClientSide && this.drilling && this.progress < 200 && this.level.getBlockState(this.worldPosition.below()).isCollisionShapeFullBlock((BlockGetter)this.level, this.worldPosition.below()) && (be = this.level.getBlockEntity(this.worldPosition.above())) instanceof BacktankBlockEntity) {
            BacktankBlockEntity t = (BacktankBlockEntity)be;
            int air = t.getAirLevel();
            if (t.getComparatorOutput() > ComparatorUtil.fractionToRedstoneLevel((double)0.2f)) {
                int op = Mth.clamp((int)(air / 80), (int)1, (int)4);
                t.setAirLevel(air - op);
                this.progress += op;
                this.notifyUpdate();
            }
        }
    }

    public void lazyTick() {
        if (this.level.isClientSide) {
            return;
        }
        this.updateVein();
        BlockEntity be = this.level.getBlockEntity(this.worldPosition.above());
        if (be instanceof BacktankBlockEntity) {
            BacktankBlockEntity t = (BacktankBlockEntity)be;
            this.airTankLevel = (float)t.getComparatorOutput() / (float)ComparatorUtil.fractionToRedstoneLevel((double)1.0);
        } else {
            this.airTankLevel = -1.0f;
        }
        this.notifyUpdate();
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putInt("progress", this.progress);
        compound.putBoolean("drilling", this.drilling);
        if (clientPacket) {
            if (this.vein != null) {
                compound.putString("veinId", this.vein.id().toString());
                compound.putLong("resRem", this.data.getResourcesRemaining((VeinRecipe)this.vein.value()));
            }
            compound.putFloat("air", this.airTankLevel);
        }
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.progress = compound.getInt("progress");
        this.drilling = compound.getBoolean("drilling");
        if (clientPacket) {
            if (compound.contains("veinId")) {
                this.veinClient = ResourceLocation.tryParse((String)compound.getString("veinId"));
                this.resourceRemClient = compound.getLong("resRem");
            } else {
                this.veinClient = null;
            }
            this.airTankLevel = compound.getFloat("air");
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public boolean clickedWithItem(Player player, InteractionHand hand) {
        if (this.progress >= 200 && this.vein != null) {
            ItemStack is = player.getItemInHand(hand);
            if (is.getItem() == Registration.VEIN_ATLAS_ITEM.get()) {
                ((OreVeinAtlasItem)Registration.VEIN_ATLAS_ITEM.get()).addVein(player, is, this.vein, new DimChunkPos(this.level, this.worldPosition), this.data.getRandomMul());
                return true;
            }
            player.displayClientMessage((Component)Component.translatable((String)"chat.coe.sampleDrill.noAtlas"), true);
        }
        return false;
    }

    public void clicked(Player player) {
        if (this.progress >= 200) {
            if (this.vein == null) {
                player.displayClientMessage((Component)Component.translatable((String)"chat.coe.veinFinder.found", (Object[])new Object[]{Component.translatable((String)"chat.coe.veinFinder.nothing")}), true);
            }
        } else if (!this.drilling) {
            if (this.airTankLevel > 0.2f) {
                this.progress = 0;
                this.drilling = true;
                player.displayClientMessage((Component)Component.translatable((String)"chat.coe.sampleDrill.start"), true);
            } else if (this.airTankLevel < 0.0f) {
                player.displayClientMessage((Component)Component.translatable((String)"chat.coe.sampleDrill.noAir"), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"chat.coe.sampleDrill.lowAir"), true);
            }
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"chat.coe.sampleDrill.running"), true);
        }
    }

    @Override
    public ItemStack getDrill() {
        return Registration.NORMAL_DRILL_ITEM.asStack();
    }

    @Override
    public BlockPos getBelow() {
        return this.worldPosition.below();
    }

    @Override
    public Direction getFacing() {
        return Direction.SOUTH;
    }

    @Override
    public boolean shouldRenderRubble() {
        return this.progress > 0;
    }

    @Override
    public float getYOffset() {
        return 1.7f;
    }

    @Override
    public float getDrillOffset() {
        return this.progress >= 200 ? 0.0f : (float)this.progress / 200.0f * 0.5f;
    }

    @Override
    public float getRotation() {
        if (this.progress >= 200) {
            return 0.0f;
        }
        if (this.progress > 0 && this.airTankLevel > 0.2f) {
            long ticks = this.getLevel().getGameTime();
            float rot = ticks * 20L % 360L;
            return rot;
        }
        return 0.0f;
    }

    @Override
    public float getPrevRotation() {
        if (this.progress >= 200) {
            return 0.0f;
        }
        if (this.progress > 0 && this.airTankLevel > 0.2f) {
            long ticks = this.getLevel().getGameTime() - 1L;
            float rot = ticks * 20L % 360L;
            return rot;
        }
        return 0.0f;
    }

    @Override
    public boolean shouldRenderShaft() {
        return (float)this.progress / 200.0f > 0.5f && this.progress < 200;
    }

    public void setDrilling(boolean drilling) {
        this.drilling = drilling;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public void setAirTankLevel(float airTankLevel) {
        this.airTankLevel = airTankLevel;
    }
}

