/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.persist.world;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.NBTProviderComponent;

public abstract class WorldStorage
implements INBTProvider {
    protected final ModBase mod;
    private INBTProvider nbtProviderComponent = new NBTProviderComponent(this);

    public WorldStorage(ModBase mod) {
        this.mod = mod;
    }

    public void readFromNBT(CompoundTag tag, HolderLookup.Provider holderLookupProvider) {
        this.readGeneratedFieldsFromNBT(tag, holderLookupProvider);
    }

    public void writeToNBT(CompoundTag tag, HolderLookup.Provider holderLookupProvider) {
        this.writeGeneratedFieldsToNBT(tag, holderLookupProvider);
    }

    public abstract void reset();

    public void onAboutToStartEvent(ServerAboutToStartEvent event) {
        this.reset();
    }

    public void onStartedEvent(ServerStartedEvent event) {
        this.reset();
        this.initDataHolder(event.getServer());
        this.afterLoad();
    }

    public void onStoppingEvent(ServerStoppingEvent event) {
        this.beforeSave();
        this.initDataHolder(event.getServer());
    }

    protected abstract String getDataId();

    private NBTDataHolder initDataHolder(MinecraftServer server) {
        return (NBTDataHolder)server.getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(() -> new NBTDataHolder(this), (t, p) -> NBTDataHolder.load(t, this, (HolderLookup.Provider)server.registryAccess())), this.mod.getModId() + "_" + this.getDataId());
    }

    public void afterLoad() {
    }

    public void beforeSave() {
    }

    @Override
    public void writeGeneratedFieldsToNBT(CompoundTag tag, HolderLookup.Provider holderLookupProvider) {
        this.nbtProviderComponent.writeGeneratedFieldsToNBT(tag, holderLookupProvider);
    }

    @Override
    public void readGeneratedFieldsFromNBT(CompoundTag tag, HolderLookup.Provider holderLookupProvider) {
        this.nbtProviderComponent.readGeneratedFieldsFromNBT(tag, holderLookupProvider);
    }

    public static class NBTDataHolder
    extends SavedData {
        private final WorldStorage parentStorage;

        public NBTDataHolder(WorldStorage parentStorage) {
            this.parentStorage = parentStorage;
        }

        public static NBTDataHolder load(CompoundTag tag, WorldStorage parentStorage, HolderLookup.Provider holderLookupProvider) {
            NBTDataHolder dataHolder = new NBTDataHolder(parentStorage);
            dataHolder.parentStorage.readFromNBT(tag, holderLookupProvider);
            return dataHolder;
        }

        public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
            this.parentStorage.writeToNBT(tag, provider);
            return tag;
        }

        public boolean isDirty() {
            return true;
        }
    }
}

