/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.item;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;

public class WeightedItemStack {
    @Nullable
    private final ItemStack itemStack;
    private final int weight;

    public static List<WeightedItemStack> createWeightedList(Set<WeightedItemStack> input) {
        LinkedList trueList = Lists.newLinkedList();
        for (WeightedItemStack itemStack : input) {
            for (int i = 0; i < itemStack.getWeight(); ++i) {
                trueList.add(itemStack);
            }
        }
        return trueList;
    }

    public static WeightedItemStack getRandomWeightedItemStack(List<WeightedItemStack> list, RandomSource random) {
        return list.get(random.nextInt(list.size()));
    }

    public ItemStack getItemStackWithRandomizedSize(RandomSource random) {
        if (this.getItemStack() == null || this.getItemStack().isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack itemStack = this.getItemStack().copy();
        itemStack.setCount(random.nextInt(itemStack.getCount()) + 1);
        return itemStack;
    }

    public String toString() {
        return "{ItemStack: " + String.valueOf(this.itemStack) + "; Weight: " + this.weight + "}";
    }

    public WeightedItemStack(@Nullable ItemStack itemStack, int weight) {
        this.itemStack = itemStack;
        this.weight = weight;
    }

    @Nullable
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeightedItemStack)) {
            return false;
        }
        WeightedItemStack other = (WeightedItemStack)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWeight() != other.getWeight()) {
            return false;
        }
        ItemStack this$itemStack = this.getItemStack();
        ItemStack other$itemStack = other.getItemStack();
        return !(this$itemStack == null ? other$itemStack != null : !this$itemStack.equals(other$itemStack));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WeightedItemStack;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWeight();
        ItemStack $itemStack = this.getItemStack();
        result = result * 59 + ($itemStack == null ? 43 : $itemStack.hashCode());
        return result;
    }
}

