/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.google.common.collect.Lists;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.infobook.AdvancedButtonEnum;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendix;

public class FurnaceRecipeAppendix
extends RecipeAppendix<SmeltingRecipe> {
    private static final int SLOT_OFFSET_X = 16;
    private static final int SLOT_OFFSET_Y = 3;
    private static final int START_X_RESULT = 68;
    private static final AdvancedButtonEnum INPUT = AdvancedButtonEnum.create();
    private static final AdvancedButtonEnum RESULT = AdvancedButtonEnum.create();

    public FurnaceRecipeAppendix(IInfoBook infoBook, RecipeHolder<? extends SmeltingRecipe> recipe) {
        super(infoBook, recipe);
    }

    @Override
    protected int getWidth() {
        return 100;
    }

    @Override
    protected int getHeightInner() {
        return 22;
    }

    @Override
    protected String getUnlocalizedTitle() {
        return "block.minecraft.furnace";
    }

    @Override
    public void bakeElement(InfoSection infoSection) {
        this.renderItemHolders.put(INPUT, new RecipeAppendix.ItemButton(this.getInfoBook()));
        this.renderItemHolders.put(RESULT, new RecipeAppendix.ItemButton(this.getInfoBook()));
        super.bakeElement(infoSection);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawElementInner(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my) {
        int middle = (width - 16) / 2;
        gui.drawArrowRight(guiGraphics, x + middle - 3, y + 3 + 2);
        int tick = this.getTick(gui);
        ItemStack input = this.prepareItemStacks(Lists.newArrayList((Object[])((Ingredient)((SmeltingRecipe)this.recipe.value()).getIngredients().get(0)).getItems()), tick);
        ItemStack result = this.prepareItemStack(((SmeltingRecipe)this.recipe.value()).getResultItem((HolderLookup.Provider)Minecraft.getInstance().player.level().registryAccess()), tick);
        this.renderItem(gui, guiGraphics, x + 16, y + 3, input, mx, my, INPUT);
        this.renderItem(gui, guiGraphics, x + 68, y + 3, result, mx, my, RESULT);
        this.renderItem(gui, guiGraphics, x + middle, y + 3, new ItemStack((ItemLike)Blocks.FURNACE), mx, my, false, null);
    }
}

