/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.cyclops.cyclopscore.inventory.IValueNotifier;

public class ValueNotifierHelpers {
    public static String KEY = "v";

    public static void setValue(IValueNotifier notifier, int valueId, Tag value) {
        CompoundTag tag = new CompoundTag();
        tag.put(KEY, value);
        notifier.setValue(valueId, tag);
    }

    public static void setValue(IValueNotifier notifier, int valueId, int value) {
        CompoundTag tag = new CompoundTag();
        tag.putInt(KEY, value);
        notifier.setValue(valueId, tag);
    }

    public static void setValue(IValueNotifier notifier, int valueId, boolean value) {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean(KEY, value);
        notifier.setValue(valueId, tag);
    }

    public static void setValue(IValueNotifier notifier, int valueId, String value) {
        CompoundTag tag = new CompoundTag();
        tag.putString(KEY, value);
        notifier.setValue(valueId, tag);
    }

    public static void setValue(IValueNotifier notifier, int valueId, MutableComponent value) {
        if (value != null) {
            CompoundTag tag = new CompoundTag();
            tag.putString(KEY, Component.Serializer.toJson((Component)value, (HolderLookup.Provider)notifier.getHolderLookupProvider()));
            notifier.setValue(valueId, tag);
        }
    }

    public static void setValue(IValueNotifier notifier, int valueId, List<MutableComponent> values) {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (Component component : values) {
            if (component == null) continue;
            list.add((Object)StringTag.valueOf((String)Component.Serializer.toJson((Component)component, (HolderLookup.Provider)notifier.getHolderLookupProvider())));
        }
        tag.put(KEY, (Tag)list);
        notifier.setValue(valueId, tag);
    }

    @Nullable
    public static Tag getValueNbt(IValueNotifier notifier, int valueId) {
        CompoundTag tag = notifier.getValue(valueId);
        if (tag != null) {
            return tag.get(KEY);
        }
        return null;
    }

    public static int getValueInt(IValueNotifier notifier, int valueId) {
        CompoundTag tag = notifier.getValue(valueId);
        if (tag != null) {
            return tag.getInt(KEY);
        }
        return 0;
    }

    public static boolean getValueBoolean(IValueNotifier notifier, int valueId) {
        CompoundTag tag = notifier.getValue(valueId);
        if (tag != null) {
            return tag.getBoolean(KEY);
        }
        return false;
    }

    @Nullable
    public static String getValueString(IValueNotifier notifier, int valueId) {
        CompoundTag tag = notifier.getValue(valueId);
        if (tag != null) {
            return tag.getString(KEY);
        }
        return null;
    }

    @Nullable
    public static MutableComponent getValueTextComponent(IValueNotifier notifier, int valueId) {
        CompoundTag tag = notifier.getValue(valueId);
        if (tag != null) {
            return Component.Serializer.fromJson((String)tag.getString(KEY), (HolderLookup.Provider)notifier.getHolderLookupProvider());
        }
        return null;
    }

    @Nullable
    public static List<MutableComponent> getValueTextComponentList(IValueNotifier notifier, int valueId) {
        CompoundTag tag = notifier.getValue(valueId);
        if (tag != null) {
            ListTag listTag = tag.getList(KEY, 8);
            ArrayList list = Lists.newArrayList();
            for (int i = 0; i < listTag.size(); ++i) {
                list.add(Component.Serializer.fromJson((String)listTag.getString(i), (HolderLookup.Provider)notifier.getHolderLookupProvider()));
            }
            return list;
        }
        return null;
    }
}

