/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.capability.registrar;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public abstract class BlockEntityCapabilityRegistrar<BE extends BlockEntity> {
    private final Supplier<BlockEntityType<? extends BE>> blockEntityType;
    private final Map<BlockCapability<?, ?>, ICapabilityProvider<? super BE, ?, ?>> registrations = Maps.newIdentityHashMap();

    public BlockEntityCapabilityRegistrar(Supplier<BlockEntityType<? extends BE>> blockEntityType) {
        this.blockEntityType = blockEntityType;
    }

    public abstract void populate();

    public final <T, C> void add(BlockCapability<T, C> capability, ICapabilityProvider<? super BE, C, T> provider) {
        this.registrations.put(capability, provider);
    }

    public final void register(RegisterCapabilitiesEvent event) {
        this.populate();
        for (Map.Entry<BlockCapability<?, ?>, ICapabilityProvider<BE, ?, ?>> entry : this.registrations.entrySet()) {
            event.registerBlockEntity(entry.getKey(), this.blockEntityType.get(), entry.getValue());
        }
    }
}

