/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.world;

import java.util.LinkedHashSet;
import java.util.Optional;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public abstract class ItemUtil {
    public static Optional<Item> getOptionalItem(String resourceKey) {
        return BuiltInRegistries.ITEM.getOptional(ResourceLocation.tryParse((String)resourceKey));
    }

    public static Item getItem(String resourceKey) {
        return (Item)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)resourceKey));
    }

    public static ItemStack getItemStack(String resourceKey) {
        return ItemUtil.getItem(resourceKey).getDefaultInstance();
    }

    public static Block getBlock(String resourceKey) {
        return (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)resourceKey));
    }

    public static Block getBlockFromItem(Item item) {
        return ItemUtil.getBlock(ItemUtil.getResourceKey(item));
    }

    public static String getResourceKey(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).toString();
    }

    public static String getResourceKey(ItemStack itemStack) {
        return ItemUtil.getResourceKey(itemStack.getItem());
    }

    public static String getResourceKey(Block block) {
        return BuiltInRegistries.ITEM.getKey((Object)block.asItem()).toString();
    }

    public static LinkedHashSet<String> getKeysFromItems(Item ... items) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (Item item : items) {
            keys.add(ItemUtil.getResourceKey(item));
        }
        return keys;
    }

    public static boolean isValidKey(String resourceKey) {
        return ItemUtil.getResourceKey(ItemUtil.getItem(resourceKey)).equals(resourceKey);
    }

    public static String getLocalizedItem(String resourceKey) {
        try {
            return ItemUtil.getItem(resourceKey).getDefaultInstance().getHoverName().getString();
        }
        catch (Throwable throwable) {
            return resourceKey;
        }
    }

    public static String getLocalizedItem(ItemStack itemStack) {
        return ItemUtil.getLocalizedItem(ItemUtil.getResourceKey(itemStack.getItem()));
    }

    public static boolean isEdible(ItemStack itemStack) {
        return itemStack.has(DataComponents.FOOD);
    }

    public static boolean isEdible(Item item) {
        return ItemUtil.isEdible(item.getDefaultInstance());
    }

    public static boolean isDamageable(ItemStack itemStack) {
        return itemStack.isDamageableItem() || itemStack.isBarVisible();
    }

    public static boolean isDamageable(Item item) {
        return ItemUtil.isDamageable(item.getDefaultInstance());
    }

    @Nullable
    public static <T extends Item> T cast(@Nullable ItemStack itemStack, Class<T> classType) {
        if (itemStack == null) {
            return null;
        }
        return (T)((Item)ClassUtil.cast(itemStack.getItem(), classType).orElse(null));
    }

    public static boolean hasCustomBarColor(ItemStack itemStack) {
        float maxDamage = itemStack.getMaxDamage();
        float damageValue = itemStack.getDamageValue();
        int color = Mth.hsvToRgb((float)(Math.max(0.0f, (maxDamage - damageValue) / maxDamage) / 3.0f), (float)1.0f, (float)1.0f);
        return itemStack.getBarColor() != color;
    }
}

