/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.world;

import mod.adrenix.nostalgic.util.common.world.ItemUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BlockUtil {
    public static Block getBlock(String resourceKey) {
        return ItemUtil.getBlock(resourceKey);
    }

    public static BlockPos getRandom(RandomSource randomSource, int bound) {
        return new BlockPos(randomSource.nextInt(bound), randomSource.nextInt(bound), randomSource.nextInt(bound));
    }

    public static boolean match(BlockState blockState, Block ... blocks) {
        for (Block block : blocks) {
            if (!blockState.is(block)) continue;
            return true;
        }
        return false;
    }

    public static boolean isChestLike(BlockState blockState) {
        return BlockUtil.isChestLike(blockState.getBlock());
    }

    public static boolean isChestLike(Block block) {
        return block instanceof AbstractChestBlock;
    }

    public static boolean isWaterLike(BlockState blockState) {
        return blockState.getFluidState().is(FluidTags.WATER);
    }

    public static boolean isNearBedrock(BlockPos blockPos, Level level) {
        return blockPos.getY() < level.getMinBuildHeight() + 5;
    }
}

