/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.timer;

import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import mod.adrenix.nostalgic.util.common.timer.SimpleTimer;

public class TickTimer {
    private final SimpleTimer timer;
    private Runnable whenFinished;
    private boolean finished;

    private TickTimer(SimpleTimer timer, Runnable whenFinished) {
        this.whenFinished = whenFinished;
        this.timer = timer;
        this.timer.waitFirst();
    }

    public Runnable getInstructions() {
        return this.whenFinished;
    }

    public void setInstructions(Runnable runnable) {
        this.whenFinished = runnable;
    }

    public double getProgress() {
        return this.timer.getProgress();
    }

    public boolean isDone() {
        return this.getProgress() >= 1.0 || this.finished;
    }

    public boolean isTicking() {
        return !this.isDone();
    }

    private boolean isFinished() {
        return this.finished;
    }

    public void reset() {
        this.timer.reset();
        this.finished = false;
    }

    public void tick() {
        if (!this.finished && this.timer.hasElapsed()) {
            this.finished = true;
            this.whenFinished.run();
        }
    }

    public static interface Manager {
        public HashSet<TickTimer> getTimers();

        default public TickTimer create(long delay, TimeUnit timeUnit, Runnable whenFinished) {
            return new TickTimer(new SimpleTimer(timeUnit.toMillis(delay), 1), whenFinished);
        }

        default public TickTimer create(long delay, TimeUnit timeUnit) {
            return new TickTimer(new SimpleTimer(timeUnit.toMillis(delay), 1), () -> {});
        }

        default public TickTimer create(long delayInMillis, Runnable whenFinished) {
            return new TickTimer(new SimpleTimer(delayInMillis, 1), whenFinished);
        }

        default public TickTimer create(long delayInMillis) {
            return new TickTimer(new SimpleTimer(delayInMillis, 1), () -> {});
        }

        default public void onTick() {
            this.getTimers().removeIf(TickTimer::isFinished);
            this.getTimers().forEach(TickTimer::tick);
        }

        default public void cancel(TickTimer timer) {
            this.getTimers().remove(timer);
            timer.finished = true;
        }

        default public void run(TickTimer timer) {
            timer.reset();
            this.getTimers().add(timer);
        }

        default public void run(TickTimer timer, Runnable whenFinished) {
            timer.setInstructions(whenFinished);
            this.run(timer);
        }

        default public void runAfter(long delayInMillis, Runnable whenFinished) {
            boolean isRunning = this.getTimers().stream().map(TickTimer::getInstructions).anyMatch(runnable -> runnable.equals(whenFinished));
            if (isRunning) {
                return;
            }
            this.getTimers().add(this.create(delayInMillis, whenFinished));
        }

        default public void runAfter(long delay, TimeUnit timeUnit, Runnable whenFinished) {
            this.runAfter(timeUnit.toMillis(delay), whenFinished);
        }
    }
}

