/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.timer;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.util.Mth;

public class LerpTimer {
    private long lengthInMillis;
    private long changedTime = -1L;
    private double targetValue = -1.0;
    private double previousValue = -1.0;

    public static LerpTimer create(long duration, TimeUnit timeUnit) {
        return new LerpTimer(timeUnit.toMillis(duration));
    }

    private LerpTimer(long lengthInMillis) {
        this.lengthInMillis = lengthInMillis;
    }

    public void setDuration(long duration, TimeUnit timeUnit) {
        this.lengthInMillis = timeUnit.toMillis(duration);
    }

    public void reset() {
        this.changedTime = -1L;
    }

    public void clear() {
        this.changedTime = -1L;
        this.previousValue = -1.0;
        this.targetValue = -1.0;
    }

    public void setTarget(Number target) {
        double value = target.doubleValue();
        long time = Util.getMillis();
        if (this.changedTime < 0L) {
            this.targetValue = value;
            this.previousValue = value;
            this.changedTime = time;
        } else if (value != this.targetValue) {
            this.previousValue = this.lerpDouble();
            this.targetValue = value;
            this.changedTime = time;
        }
    }

    public <T extends Number> T setAndGetTarget(T target, Function<LerpTimer, T> function) {
        this.setTarget(target);
        return (T)((Number)function.apply(this));
    }

    public void stopAndSetTarget(Number target) {
        double value;
        this.targetValue = value = target.doubleValue();
        this.previousValue = value;
        this.changedTime = Util.getMillis() - this.lengthInMillis;
    }

    public void ifEndThenSetTarget(Number target) {
        if (!this.isFinished()) {
            this.setTarget(target);
        } else {
            this.stopAndSetTarget(target);
        }
    }

    public double delta() {
        return Mth.clamp((float)((float)(Util.getMillis() - this.changedTime) / (float)this.lengthInMillis), (float)0.0f, (float)1.0f);
    }

    public double lerpDouble() {
        return Mth.lerp((double)this.delta(), (double)this.previousValue, (double)this.targetValue);
    }

    public float lerpFloat() {
        return (float)this.lerpDouble();
    }

    public int lerpInt() {
        return (int)this.lerpDouble();
    }

    public double endDouble() {
        return this.targetValue;
    }

    public float endFloat() {
        return (float)this.targetValue;
    }

    public int endInt() {
        return (int)this.targetValue;
    }

    public double startDouble() {
        return this.previousValue;
    }

    public float startFloat() {
        return (float)this.previousValue;
    }

    public int startInt() {
        return (int)this.previousValue;
    }

    public boolean isFinished() {
        return this.delta() >= 1.0;
    }
}

