/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.text;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import mod.adrenix.nostalgic.util.common.data.Holder;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public abstract class TextUtil {
    public static ArrayList<String> extractAll(String from, String regex) {
        ArrayList<String> results = new ArrayList<String>();
        Pattern.compile(regex).matcher(from).results().map(match -> match.group(0)).forEach(results::add);
        if (results.isEmpty()) {
            results.add("");
        }
        return results;
    }

    public static String extract(String from, String regex) {
        return TextUtil.extractAll(from, regex).getFirst();
    }

    public static String extract(String from, String regex, int groupIndex) {
        return Pattern.compile(regex).matcher(from).results().map(match -> match.group(Mth.clamp((int)groupIndex, (int)0, (int)match.groupCount()))).findFirst().orElse("");
    }

    public static String limit(String input, int amount) {
        return input.codePoints().limit(amount).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public static String replaceInRange(String input, String regex, String replacement, int start, int end) {
        String snip = input.substring(start, end);
        String result = snip.replaceAll(regex, replacement);
        return input.substring(0, start) + result + input.substring(end);
    }

    public static String getPercentColorHigh(int percent) {
        if (percent < 20) {
            return "\u00a7a" + percent + "\u00a7r";
        }
        if (percent < 40) {
            return "\u00a72" + percent + "\u00a7r";
        }
        if (percent < 60) {
            return "\u00a7e" + percent + "\u00a7r";
        }
        if (percent < 80) {
            return "\u00a76" + percent + "\u00a7r";
        }
        if (percent < 100) {
            return "\u00a7c" + percent + "\u00a7r";
        }
        return "\u00a74" + percent + "\u00a7r";
    }

    public static String getPercentColorLow(int percent) {
        if (percent <= 0) {
            return "\u00a74" + percent + "\u00a7r";
        }
        if (percent < 20) {
            return "\u00a7c" + percent + "\u00a7r";
        }
        if (percent < 40) {
            return "\u00a76" + percent + "\u00a7r";
        }
        if (percent < 60) {
            return "\u00a7e" + percent + "\u00a7r";
        }
        if (percent < 80) {
            return "\u00a72" + percent + "\u00a7r";
        }
        return "\u00a7a" + percent + "\u00a7r";
    }

    public static String toTitleCase(String convert) {
        String delimiters = " _";
        StringBuilder builder = new StringBuilder(convert.toLowerCase());
        boolean next = true;
        for (int i = 0; i < builder.length(); ++i) {
            char c = builder.charAt(i);
            c = next ? Character.toUpperCase(c) : Character.toLowerCase(c);
            builder.deleteCharAt(i);
            builder.replace(i, i, String.valueOf(c));
            boolean bl = next = delimiters.indexOf(c) >= 0;
            if (!next) continue;
            builder.deleteCharAt(i);
            builder.replace(i, i, " ");
        }
        return builder.toString();
    }

    public static String uppercaseFirstLetter(String convert) {
        if (convert.isEmpty()) {
            return convert;
        }
        char[] chars = convert.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String lowercaseFirstLetter(String convert) {
        if (convert.isEmpty()) {
            return convert;
        }
        char[] chars = convert.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static String ellipsis(Function<String, Integer> fontWidth, String in, int maxWidth) {
        if (fontWidth.apply(in) <= maxWidth) {
            return in;
        }
        StringBuilder builder = new StringBuilder(in);
        for (int i = in.length() - 1; i >= 0 && fontWidth.apply(String.valueOf(builder) + "...") > maxWidth; --i) {
            builder.deleteCharAt(i);
        }
        return String.valueOf(builder) + "...";
    }

    public static Component ellipsis(Function<String, Integer> fontWidth, Component in, int maxWidth) {
        return Component.literal((String)TextUtil.ellipsis(fontWidth, in.getString(), maxWidth));
    }

    public static Component combine(Component[] lines) {
        StringBuilder builder = new StringBuilder();
        for (Component component : lines) {
            builder.append(component.getString()).append("\n\n");
        }
        return Component.literal((String)builder.toString());
    }

    public static String colorJson(String json) {
        record Result(String replace, String color, int start, int end) {
            public void apply(Holder<String> formatting) {
                String replaceWith = String.format("%s%s%s", this.color, this.replace, ChatFormatting.RESET);
                StringBuffer buffer = new StringBuffer(formatting.get()).replace(this.start, this.end, replaceWith);
                formatting.set(buffer.toString());
            }
        }
        ArrayList<Result> results = new ArrayList<Result>();
        Holder<String> formatting = Holder.create(json);
        BiConsumer<String, String> paint = (regex, color) -> Pattern.compile(regex).matcher((CharSequence)formatting.get()).results().forEach(match -> {
            String replace = match.group(match.groupCount());
            int start = match.start(match.groupCount());
            int end = match.end(match.groupCount());
            results.add(new Result(replace, (String)color, start, end));
        });
        paint.accept("(\"([^\"]*)\")\\s*:", ChatFormatting.GRAY.toString());
        paint.accept(":\\s*(-?\\d*\\.?\\d+)", ChatFormatting.AQUA.toString());
        paint.accept(":\\s*(\\\"([^\\\"]*)\\\")", ChatFormatting.YELLOW.toString());
        paint.accept(":\\s*(true)", ChatFormatting.GREEN.toString());
        paint.accept(":\\s*(false)", ChatFormatting.RED.toString());
        results.sort(Comparator.comparingInt(Result::start));
        Lists.reverse(results).forEach(result -> result.apply(formatting));
        return formatting.get();
    }
}

