/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.network;

import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import mod.adrenix.nostalgic.NostalgicTweaks;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;

public abstract class PacketUtil {
    public static void sendToPlayer(ServerPlayer player, CustomPacketPayload packet) {
        if (NetworkManager.canPlayerReceive((ServerPlayer)player, (CustomPacketPayload.Type)packet.type())) {
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet);
            NostalgicTweaks.LOGGER.debug("(S2C) Sent (%s) to (%s)", packet, player);
        } else {
            NostalgicTweaks.LOGGER.debug("(S2C) Player (%s) cannot receive (%s)", player, packet);
        }
    }

    public static void sendToAll(Iterable<ServerPlayer> players, CustomPacketPayload packet) {
        ArrayList receivers = new ArrayList();
        players.forEach(player -> {
            if (NetworkManager.canPlayerReceive((ServerPlayer)player, (CustomPacketPayload.Type)packet.type())) {
                receivers.add(player);
            }
        });
        NetworkManager.sendToPlayers(receivers, (CustomPacketPayload)packet);
        NostalgicTweaks.LOGGER.debug("(S2C) Sent (%s) to all players", packet);
    }

    public static void sendToAll(CustomPacketPayload packet) throws NullPointerException {
        MinecraftServer server = NostalgicTweaks.getServer();
        if (server == null) {
            throw new NullPointerException(String.format("Tried to send (%s) but there was no server instance available", packet.getClass()));
        }
        PacketUtil.sendToAll(server.getPlayerList().getPlayers(), packet);
    }

    public static void sendToServer(CustomPacketPayload packet) {
        if (NostalgicTweaks.isNetworkVerified()) {
            if (NetworkManager.canServerReceive((CustomPacketPayload.Type)packet.type())) {
                NetworkManager.sendToServer((CustomPacketPayload)packet);
                NostalgicTweaks.LOGGER.debug("(C2S) Sent (%s) to server", packet);
            } else {
                NostalgicTweaks.LOGGER.debug("(C2S) Server cannot receive (%s)", packet);
            }
        } else {
            NostalgicTweaks.LOGGER.info("Mod network is unverified: Not sending (%s)", packet.getClass());
        }
    }

    public static boolean isPlayerOp(ServerPlayer player) {
        return player.hasPermissions(2);
    }

    public static void warn(Dist side, Class<?> packet) {
        String receiver = side.equals((Object)Dist.CLIENT) ? "Client" : "Server";
        String bound = side.equals((Object)Dist.CLIENT) ? "server" : "client";
        String warn = String.format("%s is processing (%s) a %s bound packet. This shouldn't happen!", receiver, packet, bound);
        NostalgicTweaks.LOGGER.warn(warn);
    }
}

