/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.math;

import java.util.Collection;
import java.util.function.ToIntFunction;
import mod.adrenix.nostalgic.util.common.math.MathUtil;

public record Rectangle(int startX, int startY, int endX, int endY) {
    public static <E> Rectangle fromCollection(Collection<E> collection, ToIntFunction<? super E> x, ToIntFunction<? super E> y) {
        int minX = collection.stream().mapToInt(x).min().orElse(0);
        int minY = collection.stream().mapToInt(y).min().orElse(0);
        int maxX = collection.stream().mapToInt(x).max().orElse(0);
        int maxY = collection.stream().mapToInt(y).max().orElse(0);
        return new Rectangle(minX, minY, maxX, maxY);
    }

    public static <E> Rectangle fromCollection(Collection<E> collection, ToIntFunction<? super E> startX, ToIntFunction<? super E> startY, ToIntFunction<? super E> endX, ToIntFunction<? super E> endY) {
        int minX = collection.stream().mapToInt(startX).min().orElse(0);
        int minY = collection.stream().mapToInt(startY).min().orElse(0);
        int maxX = collection.stream().mapToInt(endX).max().orElse(0);
        int maxY = collection.stream().mapToInt(endY).max().orElse(0);
        return new Rectangle(minX, minY, maxX, maxY);
    }

    public static Rectangle fromPoint(int pointX, int pointY) {
        return new Rectangle(pointX, pointY, pointX, pointY);
    }

    public int getWidth() {
        return Math.abs(this.endX - this.startX);
    }

    public int getHeight() {
        return Math.abs(this.endY - this.startY);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return MathUtil.isWithinBox(mouseX, mouseY, this.startX, this.startY, this.getWidth(), this.getHeight());
    }

    public static boolean intersect(Rectangle rect1, Rectangle rect2) {
        return rect1.endX >= rect2.startX && rect2.endX >= rect1.startX && rect1.endY >= rect2.startY && rect2.endY >= rect1.startY;
    }
}

