/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.tweak.factory.TweakPool;
import mod.adrenix.nostalgic.util.common.text.TextUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public abstract class DecodeLang {
    private static final String DECODE_REGEX = "@decode\\{[^=]*=[^}]*}";
    private static final String KEY_VALUE_REGEX = "@decode\\{([^=]*)=([^}]*)}";

    public static MutableComponent findAndReplace(Component input) {
        return DecodeLang.findAndReplace(input.getString());
    }

    public static MutableComponent findAndReplace(String input) {
        ArrayList results = Pattern.compile(KEY_VALUE_REGEX).matcher(input).results().map(DecodeLang::find).collect(Collectors.toCollection(ArrayList::new));
        Collections.reverse(results);
        for (Found found : results) {
            if (found.isEmpty()) continue;
            input = DecodeLang.replace(found, input);
        }
        return Component.literal((String)input);
    }

    private static Found find(MatchResult match) {
        if (match.groupCount() == 2) {
            return new Found(Key.get(match.group(1)), match.group(2), match.start(), match.end());
        }
        return Found.EMPTY;
    }

    private static String replace(Found found, String input) {
        return switch (found.key.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> input;
            case 1 -> {
                String replacement = found.value;
                Optional<Tweak<?>> tweak = TweakPool.find(found.value);
                if (tweak.isPresent()) {
                    replacement = tweak.get().getTranslation().getString();
                }
                yield TextUtil.replaceInRange(input, DECODE_REGEX, replacement, found.start, found.end);
            }
        };
    }

    private record Found(Key key, String value, int start, int end) {
        public static final Found EMPTY = new Found(Key.EMPTY, "", 0, 0);

        public boolean isEmpty() {
            return this.equals(EMPTY);
        }
    }

    private static enum Key {
        EMPTY,
        TWEAK;


        public static Key get(String input) {
            for (Key key : Key.values()) {
                if (!input.toLowerCase(Locale.ROOT).equals(key.toString())) continue;
                return key;
            }
            return EMPTY;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

