/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.data;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.util.common.function.BooleanSupplier;
import org.jetbrains.annotations.Nullable;

public class NullableHolder<T> {
    @Nullable
    private T value;

    public NullableHolder(@Nullable T value) {
        this.value = value;
    }

    public static <V> NullableHolder<V> create(@Nullable V value) {
        return new NullableHolder<V>(value);
    }

    public static <V> NullableHolder<V> empty() {
        return new NullableHolder<Object>(null);
    }

    public void set(@Nullable T value) {
        this.value = value;
    }

    @Nullable
    public T get() {
        return this.value;
    }

    public T getOrThrow() throws NoSuchElementException {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public T setAndGet(T value) {
        this.value = value;
        return value;
    }

    public void clear() {
        this.value = null;
    }

    public Optional<T> optional() {
        return Optional.ofNullable(this.value);
    }

    public T orElse(T other) {
        return this.optional().orElse(other);
    }

    public T computeIfAbsent(Supplier<T> supplier) {
        if (this.value == null) {
            this.value = supplier.get();
        }
        return this.value;
    }

    public boolean test(Predicate<T> predicate) {
        return this.optional().filter(predicate).isPresent();
    }

    public BooleanSupplier predicate(Predicate<T> predicate) {
        return () -> this.test(predicate);
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        return this.optional().map(mapper);
    }

    public void ifPresent(Consumer<? super T> consumer) {
        this.optional().ifPresent(consumer);
    }

    public void ifPresentOrElse(Consumer<? super T> consumer, Runnable runnable) {
        this.optional().ifPresentOrElse(consumer, runnable);
    }

    public boolean isEmpty() {
        return this.optional().isEmpty();
    }

    public boolean isPresent() {
        return this.optional().isPresent();
    }
}

