/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.data;

import java.util.function.Consumer;
import mod.adrenix.nostalgic.util.common.data.NullableHolder;
import org.jetbrains.annotations.Nullable;

public class NullableAction<T> {
    @Nullable
    private final T nullable;
    private final Consumer<T> action;
    private final Runnable orElse;

    public static <T> void attempt(@Nullable T nullable, Consumer<T> action) {
        new NullableAction<T>(nullable, action, () -> {}).apply();
    }

    public static <T> void attempt(@Nullable T nullable, Consumer<T> action, Runnable orElse) {
        new NullableAction<T>(nullable, action, orElse).apply();
    }

    public static <T> void attempt(NullableHolder<T> holder, Consumer<T> action) {
        new NullableAction<T>(holder.get(), action, () -> {}).apply();
    }

    public static <T> void attempt(NullableHolder<T> holder, Consumer<T> action, Runnable orElse) {
        new NullableAction<T>(holder.get(), action, orElse).apply();
    }

    private NullableAction(@Nullable T nullable, Consumer<T> action, Runnable orElse) {
        this.nullable = nullable;
        this.action = action;
        this.orElse = orElse;
    }

    private void apply() {
        if (this.nullable != null) {
            this.action.accept(this.nullable);
        } else {
            this.orElse.run();
        }
    }
}

