/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.data;

import java.util.function.Function;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.util.common.data.NullableHolder;
import org.jetbrains.annotations.Nullable;

public class CacheValue<T> {
    private final Supplier<T> supplier;
    private boolean expired;
    private T cache;

    private CacheValue(Supplier<T> supplier) {
        this.supplier = supplier;
        this.cache = supplier.get();
    }

    public static <V> CacheValue<V> create(Supplier<V> supplier) {
        return new CacheValue<V>(supplier);
    }

    public static <T, V> CacheValue<V> nullable(@Nullable T nullable, Function<T, V> function, V orElse) {
        if (nullable == null) {
            return new CacheValue<Object>(() -> orElse);
        }
        return new CacheValue<Object>(() -> function.apply(nullable));
    }

    public static <T, V> CacheValue<V> nullable(NullableHolder<T> holder, Function<T, V> function, V orElse) {
        return new CacheValue<Object>(() -> {
            if (holder.isPresent()) {
                return function.apply(holder.get());
            }
            return orElse;
        });
    }

    public static boolean isAnyExpired(CacheValue<?> ... caches) {
        for (CacheValue<?> cache : caches) {
            if (!cache.isExpired()) continue;
            return true;
        }
        return false;
    }

    public T next() {
        return this.supplier.get();
    }

    public T last() {
        return this.cache;
    }

    public void update() {
        this.cache = this.supplier.get();
        this.expired = false;
    }

    public T getAndUpdate() {
        this.update();
        return this.cache;
    }

    public boolean isExpired() {
        if (!this.expired) {
            this.expired = !this.cache.equals(this.supplier.get());
        }
        return this.expired;
    }
}

