/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.color;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.Mth;

public abstract class HexUtil {
    private static boolean isHexadecimal(String hex) {
        try {
            Integer.parseInt(hex, 16);
        }
        catch (NumberFormatException ignored) {
            return false;
        }
        return true;
    }

    public static boolean isValid(String check) {
        String[] split;
        if ((check = check.replaceAll("#", "")).length() != 6 && check.length() != 8) {
            return false;
        }
        for (String hex : split = HexUtil.splitInTwo(check)) {
            if (HexUtil.isHexadecimal(hex)) continue;
            return false;
        }
        return true;
    }

    public static int[] parseRGBA(String convert) {
        int[] rgba = new int[]{255, 255, 255, 255};
        convert = convert.replaceAll("#", "");
        if ((convert = convert.replaceAll("0x", "")).length() != 6 && convert.length() != 8) {
            return rgba;
        }
        String[] hex = HexUtil.splitInTwo(convert);
        for (int i = 0; i < hex.length; ++i) {
            if (!HexUtil.isHexadecimal(hex[i])) continue;
            rgba[i] = Integer.parseInt(hex[i], 16);
        }
        return rgba;
    }

    public static float[] parseFloatRGBA(String convert) {
        int[] rgba = HexUtil.parseRGBA(convert);
        return new float[]{(float)rgba[0] / 255.0f, (float)rgba[1] / 255.0f, (float)rgba[2] / 255.0f, (float)rgba[3] / 255.0f};
    }

    public static int parseInt(float[] rgba) {
        int r = (int)(Mth.clamp((float)rgba[0], (float)0.0f, (float)1.0f) * 255.0f);
        int g = (int)(Mth.clamp((float)rgba[1], (float)0.0f, (float)1.0f) * 255.0f);
        int b = (int)(Mth.clamp((float)rgba[2], (float)0.0f, (float)1.0f) * 255.0f);
        int a = (int)(Mth.clamp((float)rgba[3], (float)0.0f, (float)1.0f) * 255.0f);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int parseInt(String convert) {
        int[] hex = HexUtil.parseRGBA(convert);
        int r = hex[0];
        int g = hex[1];
        int b = hex[2];
        int a = hex[3];
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static String parseString(int[] rgba) {
        StringBuilder hex = new StringBuilder("#");
        for (int color : rgba) {
            if (color < 0 || color > 255) continue;
            hex.append(color <= 15 ? "0" : "").append(Integer.toHexString(color).toUpperCase());
        }
        return hex.toString();
    }

    private static String[] splitInTwo(String convert) {
        String[] split = new String[]{"FF", "FF", "FF", "FF"};
        String regex = "(..)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(convert);
        int i = -1;
        while (matcher.find()) {
            split[++i] = matcher.group(0);
        }
        return split;
    }

    public static boolean isOpaque(int color) {
        return (color >> 24 & 0xFF) == 255 || (color >> 24 & 0xFF) == 0;
    }

    public static boolean hasAlpha(int color) {
        return !HexUtil.isOpaque(color);
    }

    public static int getAlpha(int argb) {
        return argb >> 24 & 0xFF;
    }
}

