/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.color;

import mod.adrenix.nostalgic.util.common.color.Color;

public interface Gradient {
    public Direction direction();

    public Color from();

    public Color to();

    public static Gradient vertical(final Color top, final Color bottom) {
        return new Gradient(){

            @Override
            public Direction direction() {
                return Direction.VERTICAL;
            }

            @Override
            public Color from() {
                return top;
            }

            @Override
            public Color to() {
                return bottom;
            }
        };
    }

    public static Gradient horizontal(final Color left, final Color right) {
        return new Gradient(){

            @Override
            public Direction direction() {
                return Direction.HORIZONTAL;
            }

            @Override
            public Color from() {
                return left;
            }

            @Override
            public Color to() {
                return right;
            }
        };
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }
}

