/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.color;

import mod.adrenix.nostalgic.util.common.color.Color;

public enum ColorElement {
    HUE(0.0, 1.0),
    SATURATION(0.0, 1.0),
    BRIGHTNESS(0.0, 1.0),
    RED(0.0, 255.0),
    GREEN(0.0, 255.0),
    BLUE(0.0, 255.0),
    ALPHA(0.0, 1.0);

    private final double min;
    private final double max;

    private ColorElement(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public boolean isHSB() {
        return switch (this.ordinal()) {
            case 0, 1, 2 -> true;
            default -> false;
        };
    }

    public boolean isRGB() {
        return switch (this.ordinal()) {
            case 3, 4, 5 -> true;
            default -> false;
        };
    }

    public double getValue(Color color) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> color.getHue();
            case 1 -> color.getSaturation();
            case 2 -> color.getBrightness();
            case 3 -> color.getRed();
            case 4 -> color.getGreen();
            case 5 -> color.getBlue();
            case 6 -> color.getFloatAlpha();
        };
    }

    public double getInterval() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 3, 4, 5 -> 1.0;
            case 0, 1, 2, 6 -> 0.01;
        };
    }

    public void apply(Number number, Color color) {
        float[] hsb = color.getHSBComponents();
        int[] rgb = color.getIntComponents();
        float floatAlpha = color.getFloatAlpha();
        int intAlpha = color.getAlpha();
        float floatValue = number.floatValue();
        int intValue = number.intValue();
        switch (this.ordinal()) {
            case 0: {
                color.set(Color.getHSBColor(floatValue, hsb[1], hsb[2], floatAlpha));
                break;
            }
            case 1: {
                color.set(Color.getHSBColor(hsb[0], floatValue, hsb[2], floatAlpha));
                break;
            }
            case 2: {
                color.set(Color.getHSBColor(hsb[0], hsb[1], floatValue, floatAlpha));
                break;
            }
            case 3: {
                color.set(new Color(intValue, rgb[1], rgb[2], intAlpha));
                break;
            }
            case 4: {
                color.set(new Color(rgb[0], intValue, rgb[2], intAlpha));
                break;
            }
            case 5: {
                color.set(new Color(rgb[0], rgb[1], intValue, intAlpha));
                break;
            }
            case 6: {
                color.setAlpha(floatValue);
            }
        }
    }
}

