/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.asset;

import mod.adrenix.nostalgic.util.common.LocateResource;
import mod.adrenix.nostalgic.util.common.asset.GameAsset;
import mod.adrenix.nostalgic.util.common.asset.ModAsset;
import net.minecraft.resources.ResourceLocation;

public class TextureLocation {
    public static final ResourceLocation DEV_MODE = ModAsset.texture("gui/nt_dev.png");
    public static final ResourceLocation INVENTORY = ModAsset.texture("gui/inventory.png");
    public static final ResourceLocation MOJANG_ALPHA = ModAsset.texture("gui/mojang_alpha.png");
    public static final ResourceLocation MOJANG_BETA = ModAsset.texture("gui/mojang_beta.png");
    public static final ResourceLocation MOJANG_RELEASE_ORANGE = ModAsset.texture("gui/mojang_release_orange.png");
    public static final ResourceLocation MOJANG_RELEASE_BLACK = ModAsset.texture("gui/mojang_release_black.png");
    public static final ResourceLocation PANORAMA_OVERLAY = ModAsset.texture("panorama/overlay.png");
    public static final ResourceLocation DIRT_BACKGROUND = GameAsset.texture("block/dirt.png");
    public static final ResourceLocation MENU_LIST_BACKGROUND = GameAsset.texture("gui/menu_list_background.png");
    public static final ResourceLocation LEVEL_MENU_LIST_BACKGROUND = GameAsset.texture("gui/inworld_menu_list_background.png");
    public static final TextureLocation NT_LOGO_64 = new TextureLocation(ModAsset.icon("nt_logo_64.png"), 64);
    public static final TextureLocation NT_SUPPORTER_64 = new TextureLocation(ModAsset.icon("nt_supporter_64.png"), 64);
    public static final TextureLocation SOUND_16 = new TextureLocation(ModAsset.icon("sound_16.png"), 16);
    public static final TextureLocation CANDY_16 = new TextureLocation(ModAsset.icon("candy_16.png"), 16);
    public static final TextureLocation ANIMATION_16 = new TextureLocation(ModAsset.icon("animation_16.png"), 16);
    public static final TextureLocation GAMEPLAY_16 = new TextureLocation(ModAsset.icon("gameplay_16.png"), 16);
    public static final TextureLocation NOSTALGIC_TWEAKS = new TextureLocation("nostalgic_tweaks.png", 1920, 182);
    public static final String MISSING_BETA = String.format("assets/%s/textures/missing/beta.png", "nostalgic_tweaks");
    public static final String MISSING_1_5 = String.format("assets/%s/textures/missing/1_5.png", "nostalgic_tweaks");
    public static final String MISSING_1_6_1_12 = String.format("assets/%s/textures/missing/1_6-1_12.png", "nostalgic_tweaks");
    private final ResourceLocation location;
    private final int width;
    private final int height;

    public TextureLocation(ResourceLocation resourceLocation, int width, int height) {
        this.location = resourceLocation;
        this.width = width;
        this.height = height;
    }

    public TextureLocation(String path, int width, int height) {
        this.location = LocateResource.mod("textures/" + path);
        this.width = width;
        this.height = height;
    }

    public TextureLocation(ResourceLocation resourceLocation, int size) {
        this(resourceLocation, size, size);
    }

    public TextureLocation(String path, int size) {
        this(path, size, size);
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float getAverageSize() {
        return (float)(this.width + this.height) / 2.0f;
    }
}

