/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.array;

import net.minecraft.util.Mth;

public class CycleIndex {
    private final int minIndex;
    private final int maxIndex;
    private int startIndex;
    private int lastIndex;
    private int currentIndex;
    private boolean movingForward;
    private boolean resetAtEnd;

    public CycleIndex(int minIndex, int maxIndex, int startIndex, boolean resetAtEnd) {
        this.minIndex = minIndex;
        this.maxIndex = maxIndex;
        this.lastIndex = this.currentIndex = (this.startIndex = Mth.clamp((int)startIndex, (int)minIndex, (int)maxIndex));
        this.resetAtEnd = resetAtEnd;
        this.movingForward = true;
    }

    public <T> CycleIndex(T[] array, boolean resetAtEnd) {
        this(0, array.length - 1, 0, resetAtEnd);
    }

    public void cycle() {
        int nextIndex;
        this.lastIndex = this.currentIndex;
        int n = nextIndex = this.movingForward ? this.currentIndex + 1 : this.currentIndex - 1;
        if (nextIndex > this.maxIndex) {
            this.movingForward = false;
            this.currentIndex = this.resetAtEnd ? this.minIndex : --this.currentIndex;
            return;
        }
        if (nextIndex < this.minIndex) {
            this.movingForward = true;
            ++this.currentIndex;
            return;
        }
        this.currentIndex = nextIndex;
    }

    public int get() {
        return this.currentIndex;
    }

    public int getLast() {
        return this.lastIndex;
    }

    public int cycleAndGet() {
        this.cycle();
        return this.get();
    }

    public int getAndCycle() {
        int index = this.get();
        this.cycle();
        return index;
    }

    public void forward() {
        this.lastIndex = this.currentIndex;
        int nextIndex = this.currentIndex + 1;
        if (nextIndex > this.maxIndex) {
            nextIndex = this.minIndex;
            this.movingForward = false;
        }
        this.currentIndex = nextIndex;
    }

    public void backward() {
        this.lastIndex = this.currentIndex;
        int nextIndex = this.currentIndex - 1;
        if (nextIndex < this.minIndex) {
            nextIndex = this.maxIndex;
            this.movingForward = true;
        }
        this.currentIndex = nextIndex;
    }

    public void setResetAtEnd(boolean state) {
        this.resetAtEnd = state;
    }

    public void setStartIndex(int index) {
        this.startIndex = Mth.clamp((int)index, (int)this.minIndex, (int)this.maxIndex);
    }

    public void restart() {
        this.lastIndex = this.currentIndex = this.startIndex;
    }
}

