/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common;

import mod.adrenix.nostalgic.NostalgicTweaks;
import net.minecraft.util.Mth;

public abstract class ThreadMaker {
    public static Thread create(String name, final Runnable runnable) {
        return new Thread(name){

            @Override
            public void run() {
                runnable.run();
            }
        };
    }

    public static Thread create(String name, final Runnable runnable, final Runnable callback) {
        return new Thread(name){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                finally {
                    callback.run();
                }
            }
        };
    }

    public static int getNumberOfProcessors() {
        String propertyMaxThreads = System.getProperty("max.bg.threads");
        int maxThreads = 255;
        if (propertyMaxThreads != null) {
            try {
                int parsedProperty = Integer.parseInt(propertyMaxThreads);
                if (parsedProperty >= 1 && parsedProperty <= 255) {
                    maxThreads = parsedProperty;
                }
                NostalgicTweaks.LOGGER.error("Wrong %s property value '%s'. Should be an integer value between 1 and %s.", "max.bg.threads", propertyMaxThreads, 255);
            }
            catch (NumberFormatException exception) {
                NostalgicTweaks.LOGGER.error("Could not parse %s property value '%s'. Should be an integer value between 1 and %s.", "max.bg.threads", propertyMaxThreads, 255);
            }
        }
        return Mth.clamp((int)(Runtime.getRuntime().availableProcessors() - 1), (int)1, (int)maxThreads);
    }
}

