/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common;

import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public abstract class ClassUtil {
    public static boolean isInstanceOf(@Nullable Object value, Class<?> classType) {
        if (value == null) {
            return false;
        }
        return classType.isInstance(value);
    }

    public static boolean isNotInstanceOf(@Nullable Object value, Class<?> classType) {
        return !ClassUtil.isInstanceOf(value, classType);
    }

    public static boolean isClassPresent(String path) {
        try {
            Class.forName(path);
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    public static <T> Optional<T> cast(Object object, Class<T> classType) {
        return Optional.ofNullable(classType.isInstance(object) ? (Object)classType.cast(object) : null);
    }

    public static boolean isOptifinePresent() {
        return ClassUtil.isClassPresent("net.optifine.Config");
    }
}

