/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client.search.algorithm;

public abstract class NormalizedLevenshtein {
    public static double get(String entry, String query) {
        double levenshtein;
        if (entry == null) {
            throw new NullPointerException("entry must not be null");
        }
        if (query == null) {
            throw new NullPointerException("query must not be null");
        }
        if (entry.equals(query)) {
            return 1.0;
        }
        int maxLength = Math.max(entry.length(), query.length());
        double containsBoost = 1.0;
        double startsWithBoost = 1.0;
        if (maxLength == 0) {
            return 0.0;
        }
        if (entry.startsWith(query)) {
            startsWithBoost = 2.5;
        }
        if (entry.length() > 2 && query.length() > 2 && entry.contains(query)) {
            containsBoost = 1.7;
        }
        if ((levenshtein = 1.0 - NormalizedLevenshtein.distance(entry, query) / (double)maxLength) == 1.0) {
            return 1.0;
        }
        if ((levenshtein *= startsWithBoost) >= 1.0) {
            return 0.99;
        }
        if ((levenshtein *= containsBoost) >= 1.0) {
            return 0.98;
        }
        return levenshtein;
    }

    private static double distance(String entry, String query) {
        int i;
        if (entry == null) {
            throw new NullPointerException("entry must not be null");
        }
        if (query == null) {
            throw new NullPointerException("query must not be null");
        }
        if (entry.equals(query)) {
            return 0.0;
        }
        if (entry.isEmpty()) {
            return query.length();
        }
        if (query.isEmpty()) {
            return entry.length();
        }
        int[] v0 = new int[query.length() + 1];
        int[] v1 = new int[query.length() + 1];
        for (i = 0; i < v0.length; ++i) {
            v0[i] = i;
        }
        for (i = 0; i < entry.length(); ++i) {
            v1[0] = i + 1;
            int minV1 = v1[0];
            for (int j = 0; j < query.length(); ++j) {
                int cost = 1;
                if (entry.charAt(i) == query.charAt(j)) {
                    cost = 0;
                }
                v1[j + 1] = Math.min(v1[j] + 1, Math.min(v0[j + 1] + 1, v0[j] + cost));
                minV1 = Math.min(minV1, v1[j + 1]);
            }
            int[] vTemp = v0;
            v0 = v1;
            v1 = vTemp;
        }
        return v0[query.length()];
    }
}

