/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.tweak.factory.TweakMeta;
import mod.adrenix.nostalgic.tweak.factory.TweakPool;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import mod.adrenix.nostalgic.util.common.text.TextUtil;
import net.minecraft.ChatFormatting;

public enum SearchTag {
    NEW(Tweak::isNew, ChatFormatting.RED, false),
    OLD(Tweak::isOld, ChatFormatting.GRAY, false),
    CLIENT(Tweak::isClient, ChatFormatting.AQUA, false),
    SERVER(Tweak::isServer, ChatFormatting.YELLOW, false),
    DYNAMIC(Tweak::isDynamic, ChatFormatting.DARK_PURPLE, false),
    CONFLICT(Tweak::isConflictOrFail, ChatFormatting.DARK_RED, true),
    RESET(TweakMeta::isCacheNotDefault, ChatFormatting.GOLD, true),
    SAVE(TweakMeta::isAnyCacheSavable, ChatFormatting.GREEN, true);

    final Map<String, List<Tweak<?>>> map = new LinkedHashMap();
    final Predicate<Tweak<?>> predicate;
    final ChatFormatting color;
    final boolean recalculate;

    private SearchTag(Predicate<Tweak<?>> predicate, ChatFormatting color, boolean recalculate) {
        this.color = color;
        this.predicate = predicate;
        this.recalculate = recalculate;
        this.init();
    }

    public static Stream<SearchTag> stream() {
        return Arrays.stream(SearchTag.values());
    }

    public static Optional<SearchTag> get(String query) {
        String extracted = TextUtil.extract(query, "#\\w+");
        if (extracted.isEmpty()) {
            return Optional.empty();
        }
        return SearchTag.stream().filter(tag -> tag.toString().equals(extracted.replace("#", ""))).findFirst();
    }

    public static boolean isInvalid(String query) {
        if (query.startsWith("#")) {
            return SearchTag.get(query).isEmpty();
        }
        return false;
    }

    void init() {
        if (!this.map.isEmpty()) {
            this.map.clear();
        }
        TweakPool.filter(this.predicate, Tweak::isNotIgnored).forEachOrdered(tweak -> {
            String key = tweak.getTranslation().getString().toLowerCase();
            this.map.computeIfAbsent(key, str -> new ArrayList()).add(tweak);
        });
    }

    Map<String, List<Tweak<?>>> getMap() {
        if (this.recalculate) {
            this.init();
        }
        return this.map;
    }

    public String query() {
        return "#" + String.valueOf((Object)this) + " ";
    }

    public String query(String query) {
        return "#" + String.valueOf((Object)this) + " " + query;
    }

    public Predicate<Tweak<?>> getPredicate() {
        return this.predicate;
    }

    public Translation getDescription() {
        return Lang.literal("gui.nostalgic_tweaks.search_tag.info." + String.valueOf((Object)this));
    }

    public ChatFormatting getColor() {
        return this.color;
    }

    public String toDescription() {
        return this.getDescription().get(new Object[0]).getString();
    }

    public String toString() {
        return super.toString().toLowerCase(Locale.ROOT);
    }
}

