/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client.search;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mod.adrenix.nostalgic.util.client.search.LevenshteinDatabase;
import mod.adrenix.nostalgic.util.client.search.LevenshteinResult;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.util.Mth;

abstract class Database<T>
implements LevenshteinDatabase<T> {
    protected LanguageInfo languageInfo = this.getLanguage();
    protected Map<String, List<T>> map = new LinkedHashMap<String, List<T>>();
    protected double threshold = 0.01;

    Database() {
    }

    protected LanguageInfo getLanguage() {
        String code = Minecraft.getInstance().getLanguageManager().getSelected();
        return Minecraft.getInstance().getLanguageManager().getLanguage(code);
    }

    @Override
    public void setThreshold(double threshold) {
        this.threshold = Mth.clamp((double)threshold, (double)0.0, (double)1.0);
    }

    @Override
    public double getThreshold() {
        return this.threshold;
    }

    @Override
    public LevenshteinResult<T> levenshtein() {
        LanguageInfo language = this.getLanguage();
        if (this.languageInfo != language) {
            this.languageInfo = language;
            this.reset();
        }
        return LevenshteinResult.with(this.getDatabase(), this.threshold);
    }
}

