/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public abstract class MatrixUtil {
    public static float getX(Matrix4f matrix) {
        return matrix.m30();
    }

    public static float getX(PoseStack poseStack) {
        return MatrixUtil.getX(poseStack.last().pose());
    }

    public static float getX(GuiGraphics graphics) {
        return MatrixUtil.getX(graphics.pose());
    }

    public static float getY(Matrix4f matrix) {
        return matrix.m31();
    }

    public static float getY(PoseStack poseStack) {
        return MatrixUtil.getY(poseStack.last().pose());
    }

    public static float getY(GuiGraphics graphics) {
        return MatrixUtil.getY(graphics.pose());
    }

    public static float getZ(Matrix4f matrix) {
        return matrix.m32();
    }

    public static float getZ(PoseStack poseStack) {
        return MatrixUtil.getZ(poseStack.last().pose());
    }

    public static float getZ(GuiGraphics graphics) {
        return MatrixUtil.getZ(graphics.pose());
    }

    public static float getAverageScale(Matrix4f matrix) {
        Vector3f scale = matrix.getScale(new Vector3f());
        return (scale.x + scale.y + scale.z) / 3.0f;
    }

    public static float getAverageScale(PoseStack poseStack) {
        return MatrixUtil.getAverageScale(poseStack.last().pose());
    }

    public static float getAverageScale(GuiGraphics graphics) {
        return MatrixUtil.getAverageScale(graphics.pose());
    }

    public static float getScaleX(Matrix4f matrix) {
        return matrix.getScale((Vector3f)new Vector3f()).x;
    }

    public static float getScaleX(PoseStack poseStack) {
        return MatrixUtil.getScaleX(poseStack.last().pose());
    }

    public static float getScaleX(GuiGraphics graphics) {
        return MatrixUtil.getScaleX(graphics.pose());
    }

    public static float getScaleY(Matrix4f matrix) {
        return matrix.getScale((Vector3f)new Vector3f()).y;
    }

    public static float getScaleY(PoseStack poseStack) {
        return MatrixUtil.getScaleY(poseStack.last().pose());
    }

    public static float getScaleY(GuiGraphics graphics) {
        return MatrixUtil.getScaleY(graphics.pose());
    }

    public static float getScaleZ(Matrix4f matrix) {
        return matrix.getScale((Vector3f)new Vector3f()).z;
    }

    public static float getScaleZ(PoseStack poseStack) {
        return MatrixUtil.getScaleZ(poseStack.last().pose());
    }

    public static float getScaleZ(GuiGraphics graphics) {
        return MatrixUtil.getScaleZ(graphics.pose());
    }
}

