/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client.network;

import java.util.List;
import mod.adrenix.nostalgic.NostalgicTweaks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public abstract class NetUtil {
    public static boolean isPlayerOp(Player player) {
        if (Minecraft.getInstance().hasSingleplayerServer()) {
            return true;
        }
        return player.hasPermissions(2);
    }

    public static boolean isPlayerOp() {
        if (Minecraft.getInstance().player == null) {
            return true;
        }
        return NetUtil.isPlayerOp((Player)Minecraft.getInstance().player);
    }

    public static boolean isConnected() {
        return !NetUtil.isSingleplayer() && !NetUtil.isLocalHost() && NostalgicTweaks.isNetworkVerified();
    }

    public static boolean isConnectedAndOperator() {
        return NetUtil.isConnected() && NetUtil.isPlayerOp();
    }

    public static boolean isNotConnectedOrOperator() {
        return !NetUtil.isConnectedAndOperator();
    }

    public static boolean isSingleplayer() {
        return Minecraft.getInstance().getSingleplayerServer() != null && !Minecraft.getInstance().getSingleplayerServer().isPublished();
    }

    public static boolean isLocalHost() {
        return Minecraft.getInstance().getSingleplayerServer() != null && Minecraft.getInstance().getSingleplayerServer().isPublished();
    }

    @Nullable
    public static IntegratedServer getIntegratedServer() {
        return NetUtil.isLocalHost() ? Minecraft.getInstance().getSingleplayerServer() : null;
    }

    public static List<ServerPlayer> getIntegratedPlayers() {
        IntegratedServer server = NetUtil.getIntegratedServer();
        if (server == null) {
            return List.of();
        }
        return server.getPlayerList().getPlayers();
    }

    public static boolean isMultiplayer() {
        if (NetUtil.isLocalHost()) {
            return true;
        }
        return !NetUtil.isSingleplayer() && Minecraft.getInstance().getConnection() != null;
    }
}

