/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.platform.Platform;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.util.client.gui.DrawText;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import mod.adrenix.nostalgic.util.common.asset.TextureLocation;
import mod.adrenix.nostalgic.util.common.text.TextUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.Nullable;

public abstract class GuiUtil {
    @Nullable
    public static Function<Screen, Screen> modListScreen = null;
    private static boolean showFps = Platform.isDevelopmentEnvironment();

    public static void playClick() {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    public static Font font() {
        return Minecraft.getInstance().font;
    }

    public static int textHeight() {
        Objects.requireNonNull(GuiUtil.font());
        return 9;
    }

    public static Optional<Screen> getScreen() {
        Screen screen = Minecraft.getInstance().screen;
        if (screen == null) {
            return Optional.empty();
        }
        return Optional.of(screen);
    }

    public static <T extends Screen> Optional<T> getScreenAs(Class<T> classType) {
        if (GuiUtil.getScreen().isEmpty()) {
            return Optional.empty();
        }
        return ClassUtil.cast(GuiUtil.getScreen().get(), classType);
    }

    @Nullable
    public static Screen getScreenOrNull() {
        return GuiUtil.getScreen().orElse(null);
    }

    public static int getScreenWidth() {
        return GuiUtil.getScreen().stream().mapToInt(screen -> screen.width).max().orElse(0);
    }

    public static int getScreenHeight() {
        return GuiUtil.getScreen().stream().mapToInt(screen -> screen.height).max().orElse(0);
    }

    public static boolean isCurrentScreen(Screen screen) {
        return GuiUtil.getScreen().isPresent() && screen == GuiUtil.getScreen().get();
    }

    public static void renderDirtBackground(GuiGraphics graphics) {
        int width = GuiUtil.getScreenWidth();
        int height = GuiUtil.getScreenHeight();
        graphics.setColor(0.25f, 0.25f, 0.25f, 1.0f);
        graphics.blit(TextureLocation.DIRT_BACKGROUND, 0, 0, 0, 0.0f, 0.0f, width, height, 32, 32);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static Window getWindow() {
        return Minecraft.getInstance().getWindow();
    }

    public static long getWindowPointer() {
        return GuiUtil.getWindow().getWindow();
    }

    public static double getGuiScale() {
        return GuiUtil.getWindow().getGuiScale();
    }

    public static int getGuiWidth() {
        return GuiUtil.getWindow().getGuiScaledWidth();
    }

    public static int getGuiHeight() {
        return GuiUtil.getWindow().getGuiScaledHeight();
    }

    public static int getMouseX() {
        Minecraft minecraft = Minecraft.getInstance();
        double scaledWidth = minecraft.mouseHandler.xpos() * (double)GuiUtil.getGuiWidth();
        return (int)(scaledWidth / (double)minecraft.getWindow().getScreenWidth());
    }

    public static int getMouseY() {
        Minecraft minecraft = Minecraft.getInstance();
        double scaledHeight = minecraft.mouseHandler.ypos() * (double)GuiUtil.getGuiHeight();
        return (int)(scaledHeight / (double)minecraft.getWindow().getScreenHeight());
    }

    public static void enableScissor(int minX, int minY, int maxX, int maxY) {
        Window window = Minecraft.getInstance().getWindow();
        int height = window.getHeight();
        double scale = window.getGuiScale();
        double x0 = (double)minX * scale;
        double y0 = (double)height - (double)maxY * scale;
        double x1 = (double)(maxX - minX) * scale;
        double y1 = (double)(maxY - minY) * scale;
        RenderSystem.enableScissor((int)((int)x0), (int)((int)y0), (int)Math.max(0, (int)x1), (int)Math.max(0, (int)y1));
    }

    public static void disableScissor() {
        RenderSystem.disableScissor();
    }

    public static boolean isComponentEmpty(Component component) {
        String contents = component.getString();
        return component.equals((Object)Component.empty()) || contents.isEmpty() || contents.isBlank();
    }

    public static boolean isComponentEmpty(List<Component> components) {
        if (components.isEmpty()) {
            return true;
        }
        if (components.size() > 1) {
            return false;
        }
        return GuiUtil.isComponentEmpty(components.getFirst());
    }

    public static boolean isComponentPresent(Component component) {
        return !GuiUtil.isComponentEmpty(component);
    }

    public static boolean isComponentPresent(List<Component> components) {
        return !GuiUtil.isComponentEmpty(components);
    }

    public static boolean isShowingFps() {
        return showFps;
    }

    public static void setShowFps(boolean state) {
        showFps = state;
    }

    public static void toggleShowFps() {
        showFps = !showFps;
    }

    public static void renderDebug(GuiGraphics graphics) {
        if (!showFps) {
            return;
        }
        boolean isDebugging = NostalgicTweaks.isDebugging();
        float width = isDebugging ? 27.0f : 30.0f;
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 240.0f);
        RenderUtil.beginBatching();
        RenderUtil.fill(graphics, 0.0f, 0.0f, width, ((float)GuiUtil.textHeight() / 2.0f + 1.0f) * 3.0f, -1526726656);
        graphics.pose().scale(0.5f, 0.5f, 0.5f);
        graphics.pose().translate(1.0f, 2.0f, 0.0f);
        int nextX = DrawText.begin(graphics, "DEBUG: ").color(0xFFFF00).draw();
        int color = isDebugging ? 65280 : 0xFF0000;
        String state = isDebugging ? "ON" : "OFF";
        DrawText.begin(graphics, state).posX(nextX).color(color).draw();
        graphics.pose().translate(0.0f, 11.0f, 0.0f);
        nextX = DrawText.begin(graphics, "FPS: ").draw();
        DrawText.begin(graphics, String.format("%s", Minecraft.getInstance().getFps())).posX(nextX).draw();
        graphics.pose().translate(0.0f, 11.0f, 0.0f);
        nextX = DrawText.begin(graphics, "GPU: ").draw();
        String gpu = TextUtil.extract(Minecraft.getInstance().fpsString, "GPU:.+");
        String usage = TextUtil.extract(gpu, "\\d+");
        if (!usage.isEmpty()) {
            DrawText.begin(graphics, TextUtil.getPercentColorHigh(Integer.parseInt(usage)) + "%").posX(nextX).draw();
        }
        RenderUtil.endBatching();
        graphics.pose().popPose();
    }
}

