/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public abstract class DrawText {
    public static Builder begin(GuiGraphics graphics, Translation translation) {
        return new Builder(graphics, (Component)translation.get(new Object[0]));
    }

    public static Builder begin(GuiGraphics graphics, @Nullable String string) {
        return new Builder(graphics, string);
    }

    public static Builder begin(GuiGraphics graphics, @Nullable Component component) {
        return new Builder(graphics, component);
    }

    public static Builder begin(GuiGraphics graphics, @Nullable FormattedCharSequence sequence) {
        return new Builder(graphics, sequence);
    }

    public static float centerX(int startX, int width, Component text) {
        return MathUtil.center(startX, width, GuiUtil.font().width((FormattedText)text));
    }

    public static float centerX(int startX, int width, String text) {
        return MathUtil.center(startX, width, GuiUtil.font().width(text));
    }

    public static float centerY(int startY, int height) {
        return MathUtil.center(startY, height, GuiUtil.textHeight());
    }

    public static class Builder {
        private final GuiGraphics graphics;
        private float x = 0.0f;
        private float y = 0.0f;
        private int color = 0xFFFFFF;
        private boolean useIntegerX = false;
        private boolean useIntegerY = false;
        private boolean centerText = false;
        private boolean dropShadow = true;
        @Nullable
        private String string = null;
        @Nullable
        private Component component = null;
        @Nullable
        private FormattedCharSequence sequence = null;

        private Builder(GuiGraphics graphics, @Nullable String string) {
            this.graphics = graphics;
            this.string = string;
        }

        private Builder(GuiGraphics graphics, @Nullable Component component) {
            this.graphics = graphics;
            this.component = component;
        }

        private Builder(GuiGraphics graphics, @Nullable FormattedCharSequence sequence) {
            this.graphics = graphics;
            this.sequence = sequence;
        }

        public Builder posX(float x) {
            this.x = x;
            return this;
        }

        public Builder posX(int x) {
            this.useIntegerX = true;
            this.x = x;
            return this;
        }

        public Builder posY(float y) {
            this.y = y;
            return this;
        }

        public Builder posY(int y) {
            this.useIntegerY = true;
            this.y = y;
            return this;
        }

        public Builder pos(float x, float y) {
            this.posX(x);
            this.posY(y);
            return this;
        }

        public Builder pos(int x, int y) {
            this.posX(x);
            this.posY(y);
            return this;
        }

        public Builder color(Color color) {
            this.color = color.get();
            return this;
        }

        public Builder color(int argb) {
            this.color = argb;
            return this;
        }

        public Builder setShadow(boolean dropShadow) {
            this.dropShadow = dropShadow;
            return this;
        }

        public Builder flat() {
            return this.setShadow(false);
        }

        public Builder center() {
            this.centerText = true;
            return this;
        }

        public int draw() {
            if (this.centerText) {
                if (this.string != null) {
                    this.x -= (float)GuiUtil.font().width(this.string) / 2.0f;
                } else if (this.component != null) {
                    this.x -= (float)GuiUtil.font().width((FormattedText)this.component) / 2.0f;
                } else if (this.sequence != null) {
                    this.x -= (float)GuiUtil.font().width(this.sequence) / 2.0f;
                }
            }
            if (this.useIntegerX) {
                this.x = (int)this.x;
            }
            if (this.useIntegerY) {
                this.y = (int)this.y;
            }
            this.graphics.pose().pushPose();
            this.graphics.pose().translate(this.x, this.y, 0.03f);
            Font.DisplayMode mode = Font.DisplayMode.NORMAL;
            Matrix4f matrix = this.graphics.pose().last().pose();
            MultiBufferSource.BufferSource buffer = RenderUtil.fontBuffer();
            boolean isBidirectional = GuiUtil.font().isBidirectional();
            int textWidth = 0;
            if (this.string != null) {
                textWidth = GuiUtil.font().drawInBatch(this.string, 0.0f, 0.0f, this.color, this.dropShadow, matrix, (MultiBufferSource)buffer, mode, 0, 0xF000F0, isBidirectional);
            } else if (this.component != null) {
                textWidth = GuiUtil.font().drawInBatch(this.component, 0.0f, 0.0f, this.color, this.dropShadow, matrix, (MultiBufferSource)buffer, mode, 0, 0xF000F0);
            } else if (this.sequence != null) {
                textWidth = GuiUtil.font().drawInBatch(this.sequence, 0.0f, 0.0f, this.color, this.dropShadow, matrix, (MultiBufferSource)buffer, mode, 0, 0xF000F0);
            }
            this.graphics.pose().popPose();
            if (!RenderUtil.isBatching()) {
                RenderSystem.enableDepthTest();
                buffer.endBatch();
                RenderSystem.disableDepthTest();
            }
            return Math.round(this.x) + textWidth;
        }
    }
}

