/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client.gui;

import java.util.Collection;
import java.util.HashSet;
import mod.adrenix.nostalgic.tweak.enums.Corner;
import mod.adrenix.nostalgic.util.client.gui.DrawText;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.common.data.NullableResult;
import mod.adrenix.nostalgic.util.common.data.NumberHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public class CornerManager {
    private final float height = GuiUtil.getGuiHeight();
    private final NumberHolder<Double> topLeft = NumberHolder.create(2.0);
    private final NumberHolder<Double> topRight = NumberHolder.create(2.0);
    private final NumberHolder<Double> topCenter = NumberHolder.create(2.0);
    private final NumberHolder<Double> bottomLeft = NumberHolder.create((double)this.height - 10.0);
    private final NumberHolder<Double> bottomRight = NumberHolder.create((double)this.height - 10.0);

    private double getAndAdd(Corner corner) {
        return switch (corner) {
            default -> throw new MatchException(null, null);
            case Corner.TOP_LEFT -> this.topLeft.getAndAdd(10.0);
            case Corner.TOP_RIGHT -> this.topRight.getAndAdd(10.0);
            case Corner.TOP_CENTER -> this.topCenter.getAndAdd(10.0);
            case Corner.BOTTOM_LEFT -> this.bottomLeft.getAndAdd(-10.0);
            case Corner.BOTTOM_RIGHT -> this.bottomRight.getAndAdd(-10.0);
        };
    }

    private int getRightOffset(String text) {
        return GuiUtil.getGuiWidth() - GuiUtil.font().width(text) - 2;
    }

    public void drawText(GuiGraphics graphics, String text, Corner corner) {
        this.drawText(graphics, text, corner, 0, 0, true);
    }

    public void drawText(GuiGraphics graphics, String text, Corner corner, int xOffset, int yOffset, boolean dropShadow) {
        float x = (corner.isLeft() ? 2 : this.getRightOffset(text)) + xOffset;
        float y = (int)this.getAndAdd(corner) + yOffset;
        if (corner == Corner.TOP_RIGHT) {
            EffectRenderingInventoryScreen screen;
            boolean areEffectsHidden;
            LocalPlayer player = Minecraft.getInstance().player;
            Collection effects = NullableResult.getOrElse(player, new HashSet(), LivingEntity::getActiveEffects);
            Screen screen2 = Minecraft.getInstance().screen;
            boolean bl = areEffectsHidden = screen2 instanceof EffectRenderingInventoryScreen && (screen = (EffectRenderingInventoryScreen)screen2).canSeeEffects();
            if (!effects.isEmpty() && !areEffectsHidden) {
                boolean hasBeneficial = effects.stream().map(MobEffectInstance::getEffect).map(Holder::value).anyMatch(mobEffect -> !mobEffect.isBeneficial());
                if (effects.stream().anyMatch(MobEffectInstance::showIcon)) {
                    y += 24.0f;
                }
                if (hasBeneficial) {
                    y += 26.0f;
                }
            }
        }
        if (corner == Corner.TOP_CENTER) {
            x = DrawText.centerX(0, GuiUtil.getGuiWidth(), text);
        }
        x = Mth.clamp((float)x, (float)0.0f, (float)(GuiUtil.getGuiWidth() - GuiUtil.font().width(text)));
        y = Mth.clamp((float)y, (float)0.0f, (float)(GuiUtil.getGuiHeight() - GuiUtil.textHeight()));
        DrawText.begin(graphics, text).pos(x, y).setShadow(dropShadow).draw();
    }
}

